/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActions.mappers;

import com.atlassian.confluence.api.model.JsonString;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.JsonContentProperty;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.actions.ProfilePictureInfo;
import com.atlassian.user.User;
import com.comalatech.confluence.dataextractor.model.ApprovalContentPropertyModel;
import com.comalatech.confluence.documentActions.mappers.DocumentActionsMapper;
import com.comalatech.confluence.documentActions.rest.model.ActionReport;
import com.comalatech.confluence.documentActions.services.model.ActionsSearchResult;
import com.comalatech.confluence.documentActions.services.model.PendingApprovals;
import com.comalatech.confluence.documentActions.services.model.search.ActionTypes;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.workflow.ApprovalAccessor;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.workflow.StateService;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PendingApprovalsMapper
implements DocumentActionsMapper {
    private static final Logger log = LoggerFactory.getLogger(PendingApprovalsMapper.class);
    public static final String COMALA_WORKFLOWS_APPROVALS_KEY = "comalaworkflowsapprovals";
    public static final String APPROVALS_NAME_PREFIX = "approvalv2-";
    private final ObjectMapper jsonMapper;
    private final PageManager pageManager;
    private final ApprovalAccessor approvalAccessor;
    private final StateService stateService;
    private final UserAccessor userAccessor;

    public PendingApprovalsMapper(ObjectMapper jsonMapper, ApprovalAccessor approvalAccessor, PageManager pageManager, StateService stateService, UserAccessor userAccessor) {
        this.jsonMapper = jsonMapper;
        this.approvalAccessor = approvalAccessor;
        this.pageManager = pageManager;
        this.stateService = stateService;
        this.userAccessor = userAccessor;
    }

    @Override
    public ActionsSearchResult map(ActionsSearchResult actionsSearchResult, ConfluenceUser assignedUser, Content contentEntity, Map.Entry<String, JsonContentProperty> jsonContentEntry) {
        AbstractPage page;
        if (actionsSearchResult == null) {
            actionsSearchResult = new ActionsSearchResult();
        }
        if (jsonContentEntry != null && COMALA_WORKFLOWS_APPROVALS_KEY.equals(jsonContentEntry.getKey()) && (page = this.pageManager.getAbstractPage(contentEntity.getId().asLong())) != null) {
            List<PendingApprovals> pendingApprovals = this.mapJsonToApprovalsContent(jsonContentEntry.getValue().getValue()).stream().filter(approvalPropertyModel -> this.isAssignedUserPresent((ApprovalContentPropertyModel)approvalPropertyModel, assignedUser)).map(approvalPropertyModel -> this.toPendingApprovals(this.retrieveApprovalCheck((ApprovalContentPropertyModel)approvalPropertyModel, page), (ApprovalContentPropertyModel)approvalPropertyModel, page, assignedUser)).filter(Objects::nonNull).collect(Collectors.toList());
            actionsSearchResult.setPendingApprovals(pendingApprovals);
        }
        return actionsSearchResult;
    }

    private boolean isAssignedUserPresent(ApprovalContentPropertyModel approval, ConfluenceUser assignedUser) {
        return approval.pendingApprovers != null && approval.pendingApprovers.getUserKeyList().contains(assignedUser.getKey().getStringValue());
    }

    private ApprovalCheck retrieveApprovalCheck(ApprovalContentPropertyModel approval, AbstractPage page) {
        PageState pageState = (PageState)this.stateService.getCurrentState((ContentEntityObject)page);
        return this.approvalAccessor.getLatestApprovalCheck(page, pageState, approval.name, 0);
    }

    private List<ApprovalContentPropertyModel> mapJsonToApprovalsContent(JsonString approvalsJsonContent) {
        ApprovalContentPropertyModel[] approvals = null;
        try {
            approvals = (ApprovalContentPropertyModel[])this.jsonMapper.readValue(approvalsJsonContent.getValue(), ApprovalContentPropertyModel[].class);
        }
        catch (Exception ex) {
            log.warn("Cannot extract approvals data list {} : {}", new Object[]{approvalsJsonContent, this, ex});
        }
        return approvals != null ? Arrays.asList(approvals) : Collections.emptyList();
    }

    private PendingApprovals toPendingApprovals(ApprovalCheck approvalCheck, ApprovalContentPropertyModel approvalPropertyModel, AbstractPage page, ConfluenceUser assignedUser) {
        PendingApprovals approval = new PendingApprovals();
        if (approvalCheck == null) {
            log.info("Approval Check is null for approval " + approvalPropertyModel.name);
            return null;
        }
        if (page != null) {
            this.getContentDetails(approval, page);
        }
        approval.setType(ActionTypes.APPROVAL);
        approval.setName(approvalCheck.getName());
        approval.setId(APPROVALS_NAME_PREFIX + approvalCheck.getName().hashCode());
        approval.setHasCondition(approvalPropertyModel.hasCondition);
        Optional<ApprovalCheck.AssigneeHistory> assigneeHistory = approvalCheck.getAssigneeHistory().stream().filter(assignee -> assignee.isUserAssigned(assignedUser.getName())).findFirst();
        assigneeHistory.ifPresent(history -> this.getAssigneeHistory(approval, (ApprovalCheck.AssigneeHistory)history));
        return approval;
    }

    private void getAssigneeHistory(PendingApprovals approval, ApprovalCheck.AssigneeHistory assigneeHistory) {
        approval.setDetails(StringUtils.trimToNull((String)assigneeHistory.getComment()));
        if (assigneeHistory.getDate() != null) {
            approval.setAssignmentDate(assigneeHistory.getDate().toInstant().toEpochMilli());
        }
        if (assigneeHistory.getDueDate() != null) {
            approval.setDueDate(assigneeHistory.getDueDate().toInstant().toEpochMilli());
        }
        ActionReport.AssignerDetails assignerDetails = approval.new ActionReport.AssignerDetails();
        assignerDetails.setUsername(assigneeHistory.getPerformer());
        ConfluenceUser assignerUser = this.userAccessor.getUserByName(assigneeHistory.getPerformer());
        if (assignerUser != null) {
            assignerDetails.setDisplayName(assignerUser.getFullName());
            ProfilePictureInfo userProfilePicture = this.userAccessor.getUserProfilePicture((User)assignerUser);
            assignerDetails.setAvatarUrl(userProfilePicture.getUriReference());
        }
        approval.setAssignerDetails(assignerDetails);
    }

    private void getContentDetails(PendingApprovals pendingApproval, AbstractPage content) {
        ActionReport.ContentDetails contentDetails = pendingApproval.new ActionReport.ContentDetails();
        contentDetails.setId(content.getId());
        contentDetails.setUrl(content.getUrlPath());
        contentDetails.setSpaceName(content.getSpace().getName());
        contentDetails.setTitle(content.getDisplayTitle());
        contentDetails.setType(content.getTypeEnum().getRepresentation());
        if (ContentTypeEnum.PAGE == content.getTypeEnum()) {
            contentDetails.setHome(((Page)content).isHomePage());
        }
        pendingApproval.setContentDetails(contentDetails);
    }
}

