/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

AWP.View.ActivityTab = Backbone.View.extend({
    // backbone properties
    id : "activity",
    icon: "activity",
    tagName : "div",
    className : "tabs-pane",
    
    // custom prop
    caption : AJS.I18n.getText("adhocworkflows.tab.activity"),
    
    render: function () {
        // I think we should not do ajax calls from views, or yes?
        // But i don't think necessary to use a model for this?
        var url = AWP.contextPath + "/plugins/adhocworkflows/viewactivity.action?pageId=" + AWP.pageId;
        
        AJS.$.ajax({
            cache: false,
            contentType: "application/json; charset=utf-8",
            url: url,
            success: _.bind(function(content, textStatus, jqXHR) {
                this.$el.html(content);
                this.$('.awp-activity').addClass('awp-list');
                this.openLinksWindow();
            }, this)
        });
        return this;
    },

    /**
     * Links in the activity stream will be opened at a new window
     */
    openLinksWindow: function () {
        AJS.$('#' + this.id + ' a').on('click', function(evt) {
            evt.currentTarget.target = "_blank";
        });
    },
    
    reload: function () {
        this.render();
    }
});