/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.pageactivity;

import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.workflowreports.ReportDateFormatter;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityCsvConfig;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityCsvEntryProcessorAO;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityCsvProcessor;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityCsvService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocActivityCsvServiceImpl
implements PageActivityCsvService<Activity> {
    private static final Logger log = LoggerFactory.getLogger(DocActivityCsvServiceImpl.class);
    private final PageActivityCsvProcessor aoProcessor;

    public DocActivityCsvServiceImpl(LocaleManager localeManager, PageManager pageManager, I18nResolver i18nResolver) {
        ReportDateFormatter dateFormatter = new ReportDateFormatter(localeManager);
        this.aoProcessor = new PageActivityCsvEntryProcessorAO(pageManager, dateFormatter, i18nResolver);
    }

    @Override
    public String getPageActivityFileContent(List<Activity> entries, AbstractPage page, PageActivityCsvConfig pageActivityCsvConfig) {
        this.aoProcessor.setPageActivityCsvConfig(pageActivityCsvConfig);
        if (entries.size() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        this.aoProcessor.generateHeaders(builder);
        for (Activity entry : entries) {
            this.aoProcessor.processEntry(builder, page, entry);
        }
        return builder.toString();
    }
}

