/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowcontainer.model;

import com.comalatech.confluence.workflowcontainer.model.RemoteWorkflow;
import com.comalatech.confluence.workflowcontainer.model.RemoteWorkflowCategory;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class RemoteWorkflowsRepository
extends ArrayList<RemoteWorkflow> {
    private Date date;
    private Date loadTime;
    private Set<RemoteWorkflowCategory> categories;
    private String status;
    private boolean learnMoreEnabled;

    public RemoteWorkflowsRepository(Date date, boolean learnMoreEnabled) {
        this.date = date;
        this.learnMoreEnabled = learnMoreEnabled;
        this.categories = new HashSet<RemoteWorkflowCategory>();
    }

    @Override
    public boolean add(RemoteWorkflow remoteWorkflow) {
        remoteWorkflow.addCategories(this.categories);
        return super.add(remoteWorkflow);
    }

    public RemoteWorkflow get(String id) {
        for (RemoteWorkflow remoteWorkflow : this) {
            if (!remoteWorkflow.getId().equals(id)) continue;
            return remoteWorkflow;
        }
        return null;
    }

    public RemoteWorkflowsRepository removeIfNotInCategory(String categoryId) {
        if (!TextUtils.stringSet((String)categoryId)) {
            return this;
        }
        this.removeIf(remoteWorkflow -> !remoteWorkflow.hasCategory(categoryId));
        return this;
    }

    public Set<RemoteWorkflowCategory> getCategories() {
        return this.categories;
    }

    public Date getDate() {
        return this.date;
    }

    public Date getLoadTime() {
        return this.loadTime;
    }

    public void refreshLoadTime() {
        this.loadTime = new Date();
    }

    public String getStatus() {
        return this.status;
    }

    public boolean isLearnMoreEnabled() {
        return this.learnMoreEnabled;
    }

    public void setStatus(String status) {
        this.status = status;
    }
}

