/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.rest.model;

import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostCreateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostUpdateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentCreateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentRemoveEvent;
import com.atlassian.confluence.event.events.content.comment.CommentUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageMoveEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.event.events.label.LabelAddEvent;
import com.atlassian.confluence.event.events.label.LabelRemoveEvent;
import com.atlassian.confluence.plugins.inlinecomments.events.InlineCommentCreateEvent;
import com.atlassian.confluence.plugins.inlinecomments.events.InlineCommentResolveEvent;
import com.comalatech.confluence.states.event.BlogPostAssignEvent;
import com.comalatech.confluence.states.event.BlogPostStateTransitionEvent;
import com.comalatech.confluence.states.event.BlogPostUnassignEvent;
import com.comalatech.confluence.states.event.PageAssignEvent;
import com.comalatech.confluence.states.event.PageStateTransitionEvent;
import com.comalatech.confluence.states.event.PageUnassignEvent;
import com.comalatech.confluence.states.event.StateExpireEvent;
import com.comalatech.confluence.states.event.StateExpiryUpdatedEvent;
import com.comalatech.confluence.states.event.TaskAssignEvent;
import com.comalatech.confluence.states.event.TaskCompleteEvent;
import com.comalatech.confluence.states.event.TaskCreateEvent;
import com.comalatech.confluence.workflow.events.BlogPostApprovalApproveEvent;
import com.comalatech.confluence.workflow.events.BlogPostApprovalAssignedEvent;
import com.comalatech.confluence.workflow.events.BlogPostApprovalEvent;
import com.comalatech.confluence.workflow.events.BlogPostApprovalRejectEvent;
import com.comalatech.confluence.workflow.events.DefaultApprovalUnassignedEvent;
import com.comalatech.confluence.workflow.events.InternalApprovalEvent;
import com.comalatech.confluence.workflow.events.PageApprovalApproveEvent;
import com.comalatech.confluence.workflow.events.PageApprovalAssignedEvent;
import com.comalatech.confluence.workflow.events.PageApprovalEvent;
import com.comalatech.confluence.workflow.events.PageApprovalRejectEvent;
import com.comalatech.confluence.workflow.events.WorkflowAttachmentChangedEvent;
import com.comalatech.confluence.workflow.events.WorkflowAttachmentCreateEvent;
import com.comalatech.confluence.workflow.events.WorkflowAttachmentRemoveEvent;
import com.comalatech.confluence.workflow.events.WorkflowAttachmentUpdateEvent;
import com.comalatech.confluence.workflow.events.WorkflowAttachmentVersionRemoveEvent;
import com.comalatech.confluence.workflow.events.WorkflowPageParameterUpdatedEventImpl;
import com.comalatech.confluence.workflow.rest.model.Condition;
import com.comalatech.confluence.workflowcontainer.model.SerializableMacro;
import com.comalatech.workflow.event.TaskDueDateExpiredEvent;
import com.webcohesion.enunciate.metadata.DocumentationExample;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.codehaus.jackson.annotate.JsonSubTypes;
import org.codehaus.jackson.annotate.JsonTypeInfo;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Trigger {
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=Event.class, name="event"), @JsonSubTypes.Type(value=TaskEvent.class, name="task"), @JsonSubTypes.Type(value=StateEvent.class, name="state"), @JsonSubTypes.Type(value=ApprovalEvent.class, name="approval"), @JsonSubTypes.Type(value=LabelEvent.class, name="label"), @JsonSubTypes.Type(value=WorkflowPageParameterEvent.class, name="parameter")})
    public Event event;
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=Condition.PermissionCondition.class, name="permission"), @JsonSubTypes.Type(value=Condition.MetadataCondition.class, name="metadata"), @JsonSubTypes.Type(value=Condition.StateCondition.class, name="state"), @JsonSubTypes.Type(value=Condition.SpaceCondition.class, name="space"), @JsonSubTypes.Type(value=Condition.PageCondition.class, name="page"), @JsonSubTypes.Type(value=Condition.UserCondition.class, name="user"), @JsonSubTypes.Type(value=Condition.GroupCondition.class, name="group"), @JsonSubTypes.Type(value=Condition.ExcludeCondition.class, name="exclude"), @JsonSubTypes.Type(value=Condition.HasApprovalCondition.class, name="hasapproval"), @JsonSubTypes.Type(value=Condition.HasLabelCondition.class, name="haslabel")})
    public List<Condition> conditions;
    @DocumentationExample(value="{send-email:user=admin|subject=Page ready for final approval}\\n The page @page@ has been approved by [~@user@] and is waiting for your final approval.\\n  {pageactivity}\\n {send-email}")
    public String action;

    public Trigger() {
    }

    public Trigger(com.comalatech.confluence.workflow.model.Trigger trigger) {
        com.comalatech.confluence.states.event.StateEvent stateEvent;
        InternalApprovalEvent approvalEvent;
        LabelAddEvent labelEvent;
        ConfluenceEvent event = trigger.getEvent();
        if (event instanceof LabelAddEvent) {
            labelEvent = (LabelAddEvent)event;
            this.event = new LabelEvent("label-added", labelEvent.getLabel().toString());
        } else if (event instanceof LabelRemoveEvent) {
            labelEvent = (LabelRemoveEvent)event;
            this.event = new LabelEvent("label-removed", labelEvent.getLabel().toString());
        } else if (event instanceof PageApprovalApproveEvent) {
            approvalEvent = (PageApprovalApproveEvent)event;
            this.event = new ApprovalEvent("approval-approved", "page", ((PageApprovalEvent)approvalEvent).getApprovalName(), ((PageApprovalEvent)approvalEvent).isPartial());
        } else if (event instanceof PageApprovalRejectEvent) {
            approvalEvent = (PageApprovalRejectEvent)event;
            this.event = new ApprovalEvent("approval-rejected", "page", ((PageApprovalEvent)approvalEvent).getApprovalName(), ((PageApprovalEvent)approvalEvent).isPartial());
        } else if (event instanceof PageApprovalAssignedEvent) {
            approvalEvent = (PageApprovalAssignedEvent)event;
            this.event = new ApprovalEvent("approval-assigned", "page", ((PageApprovalEvent)approvalEvent).getApprovalName());
        } else if (event instanceof BlogPostApprovalApproveEvent) {
            approvalEvent = (BlogPostApprovalApproveEvent)event;
            this.event = new ApprovalEvent("approval-approved", "blog", ((BlogPostApprovalEvent)approvalEvent).getApprovalName(), ((BlogPostApprovalEvent)approvalEvent).isPartial());
        } else if (event instanceof BlogPostApprovalRejectEvent) {
            approvalEvent = (BlogPostApprovalRejectEvent)event;
            this.event = new ApprovalEvent("approval-rejected", "blog", ((BlogPostApprovalEvent)approvalEvent).getApprovalName(), ((BlogPostApprovalEvent)approvalEvent).isPartial());
        } else if (event instanceof BlogPostApprovalAssignedEvent) {
            approvalEvent = (BlogPostApprovalAssignedEvent)event;
            this.event = new ApprovalEvent("approval-assigned", "blog", ((BlogPostApprovalEvent)approvalEvent).getApprovalName());
        } else if (event instanceof DefaultApprovalUnassignedEvent) {
            approvalEvent = (DefaultApprovalUnassignedEvent)event;
            this.event = new ApprovalEvent("approval-unassigned", null, ((DefaultApprovalUnassignedEvent)approvalEvent).getApprovalName());
        } else if (event instanceof PageCreateEvent) {
            this.event = new Event("page-created");
        } else if (event instanceof PageUpdateEvent) {
            this.event = new Event("page-updated");
        } else if (event instanceof PageMoveEvent) {
            this.event = new Event("page-moved");
        } else if (event instanceof BlogPostCreateEvent) {
            this.event = new Event("blog-created");
        } else if (event instanceof BlogPostUpdateEvent) {
            this.event = new Event("blog-updated");
        } else if (event instanceof PageStateTransitionEvent) {
            stateEvent = (PageStateTransitionEvent)event;
            this.event = new StateEvent("state-changed", ((PageStateTransitionEvent)stateEvent).getState().getName(), ((PageStateTransitionEvent)stateEvent).isInitial());
        } else if (event instanceof StateExpireEvent) {
            stateEvent = (StateExpireEvent)event;
            this.event = new StateEvent("state-expired", ((StateExpireEvent)stateEvent).getState().getName(), false);
        } else if (event instanceof StateExpiryUpdatedEvent) {
            stateEvent = (StateExpiryUpdatedEvent)event;
            this.event = new StateEvent("state-expiry-updated", ((StateExpiryUpdatedEvent)stateEvent).getState().getName(), false);
        } else if (event instanceof BlogPostStateTransitionEvent) {
            stateEvent = (BlogPostStateTransitionEvent)event;
            this.event = new StateEvent("blog-state-changed", ((BlogPostStateTransitionEvent)stateEvent).getState().getName(), false);
        } else if (event instanceof WorkflowAttachmentCreateEvent) {
            this.event = new Event("attachment-added");
        } else if (event instanceof WorkflowAttachmentRemoveEvent) {
            this.event = new Event("attachment-removed");
        } else if (event instanceof WorkflowAttachmentVersionRemoveEvent) {
            this.event = new Event("attachment-version-removed");
        } else if (event instanceof WorkflowAttachmentUpdateEvent) {
            this.event = new Event("attachment-updated");
        } else if (event instanceof WorkflowAttachmentChangedEvent) {
            this.event = new Event("attachments-change");
        } else if (event instanceof PageAssignEvent) {
            this.event = new Event("page-assigned");
        } else if (event instanceof PageUnassignEvent) {
            this.event = new Event("page-unassigned");
        } else if (event instanceof BlogPostAssignEvent) {
            this.event = new Event("blog-assigned");
        } else if (event instanceof BlogPostUnassignEvent) {
            this.event = new Event("blog-unassigned");
        } else if (event instanceof TaskCreateEvent) {
            this.event = new TaskEvent("task-created", this.getTaskName(event));
        } else if (event instanceof TaskAssignEvent) {
            this.event = new TaskEvent("task-assigned", this.getTaskName(event));
        } else if (event instanceof TaskCompleteEvent) {
            this.event = new TaskEvent("task-completed", this.getTaskName(event));
        } else if (event instanceof TaskDueDateExpiredEvent) {
            this.event = new TaskEvent("task-expired", this.getTaskName(event));
        } else if (event instanceof WorkflowPageParameterUpdatedEventImpl) {
            this.event = new WorkflowPageParameterEvent("page-parameter-update", ((WorkflowPageParameterUpdatedEventImpl)event).getWorkflowParameter().getName());
        } else if (event instanceof CommentCreateEvent) {
            this.event = new Event("page-comment-created");
        } else if (event instanceof CommentRemoveEvent) {
            this.event = new Event("page-comment-removed");
        } else if (event instanceof CommentUpdateEvent) {
            this.event = new Event("page-comment-updated");
        } else if (event instanceof InlineCommentCreateEvent) {
            this.event = new Event("inline-comment-created");
        } else if (event instanceof InlineCommentResolveEvent) {
            this.event = new Event("inline-comment-resolved");
        }
        if (!trigger.getConditions().isEmpty()) {
            this.conditions = new ArrayList<Condition>();
            for (com.comalatech.confluence.workflow.model.Condition triggerCondition : trigger.getConditions()) {
                SerializableMacro macro = new SerializableMacro("dummy");
                triggerCondition.addMacroParameters(macro);
                SerializableMacro.ParsedParameters params = macro.getParameters();
                Condition condition = Condition.build(params);
                if (condition == null) continue;
                this.conditions.add(condition);
            }
        }
        this.action = trigger.getAction();
    }

    private String getTaskName(ConfluenceEvent event) {
        com.comalatech.confluence.states.event.TaskEvent taskEvent = (com.comalatech.confluence.states.event.TaskEvent)event;
        if (taskEvent.getTask() == null) {
            return null;
        }
        return taskEvent.getTask().getName();
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class WorkflowPageParameterEvent
    extends Event {
        @DocumentationExample(value="Page Editor")
        public String parameter;

        public WorkflowPageParameterEvent() {
        }

        public WorkflowPageParameterEvent(String name, String parameter) {
            super(name);
            this.parameter = parameter;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class LabelEvent
    extends Event {
        @DocumentationExample(value="label2")
        public String label;

        public LabelEvent() {
        }

        public LabelEvent(String name, String label) {
            super(name);
            this.label = label;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class ApprovalEvent
    extends Event {
        @DocumentationExample(value="page")
        public String content;
        @DocumentationExample(value="Review Approval")
        public String approval;
        @DocumentationExample(value="true")
        public Boolean partial;

        public ApprovalEvent() {
        }

        public ApprovalEvent(String name, String content, String approval) {
            super(name);
            this.content = content;
            this.approval = approval;
        }

        public ApprovalEvent(String name, String content, String approval, Boolean partial) {
            this(name, content, approval);
            this.partial = partial != false ? Boolean.valueOf(true) : null;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class StateEvent
    extends Event {
        @DocumentationExample(value="Final State")
        public String state;
        @DocumentationExample(value="false")
        public Boolean initial;

        public StateEvent() {
        }

        public StateEvent(String name, String state, Boolean initial) {
            super(name);
            this.state = state;
            this.initial = initial != false ? Boolean.valueOf(true) : null;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class TaskEvent
    extends Event {
        @DocumentationExample(value="task1")
        String task;

        public TaskEvent() {
        }

        public TaskEvent(String name, String task) {
            super(name);
            this.task = task;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Event {
        public String name;

        public Event() {
        }

        public Event(String name) {
            this.name = name;
        }
    }
}

