/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.analytics;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.core.ConfluenceSidManager;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.comalatech.confluence.analytics.StatField;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.analytics.CommonAnalyticsManager;
import com.comalatech.confluence.workflow.analytics.ESignatureStatsGatherer;
import com.comalatech.confluence.workflow.analytics.ReadAckInformationGatherer;
import com.comalatech.confluence.workflow.analytics.UpgradeStatsGatherer;
import com.comalatech.confluence.workflow.analytics.usecases.appsusagesharing.contracts.AppUsageAnalyticsManager;
import com.comalatech.confluence.workflow.service.ApprovalsSearchService;
import com.comalatech.confluence.workflow.stats.WorkflowStatisticsManager;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Manifest;

public class DefaultAppUsageAnalyticsManager
extends CommonAnalyticsManager
implements AppUsageAnalyticsManager {
    protected final ReadAckInformationGatherer readAckInformationGatherer;
    protected final ESignatureStatsGatherer eSignatureStatsGatherer;

    public DefaultAppUsageAnalyticsManager(BandanaManager bandanaManager, ConfluenceSidManager confluenceSidManager, SystemInformationService systemInformationService, PluginAccessor pluginAccessor, PluginLicenseManager pluginLicenseManager, SearchManager searchManager, ApprovalsSearchService approvalsSearchService, WorkflowsFeatureManager workflowsFeatureManager, WorkflowStatisticsManager workflowStatisticsManager, ReadAckInformationGatherer readAckInformationGatherer, ESignatureStatsGatherer eSignatureStatsGatherer, SpaceManager spaceManager, UpgradeStatsGatherer upgradeStatsGatherer) {
        super(bandanaManager, confluenceSidManager, systemInformationService, pluginAccessor, pluginLicenseManager, searchManager, approvalsSearchService, spaceManager, workflowsFeatureManager, readAckInformationGatherer, eSignatureStatsGatherer, workflowStatisticsManager, upgradeStatsGatherer);
        this.readAckInformationGatherer = readAckInformationGatherer;
        this.eSignatureStatsGatherer = eSignatureStatsGatherer;
    }

    @Override
    public Map<String, Object> getAppUsageStats() {
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        Arrays.stream(this.getStatFields()).forEach(f -> valuesMap.put(f.getName(), f.getProcessor().execute()));
        return valuesMap;
    }

    @Override
    protected StatField[] getDefaultStatFields() {
        return new StatField[]{new StatField("timestamp", () -> new Date().getTime()), new StatField("app", () -> this.getFriendApps().entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(this.pluginLicenseManager.getPluginKey())).findFirst().map(Map.Entry::getValue).orElse("---")), new StatField("pluginLicenseSize", () -> {
            if (this.pluginLicenseManager.getLicense().isDefined()) {
                return ((PluginLicense)this.pluginLicenseManager.getLicense().get()).getEdition().getOrElse((Object)0);
            }
            return -1;
        }), new StatField("pluginLicenseType", () -> {
            if (this.pluginLicenseManager.getLicense().isDefined()) {
                PluginLicense license = (PluginLicense)this.pluginLicenseManager.getLicense().get();
                if (license.isEvaluation()) {
                    return "EVALUATION";
                }
                if (license.isValid()) {
                    return "PAID";
                }
                if (license.getError().isDefined()) {
                    return "ERROR";
                }
            }
            return "INVALID";
        }), new StatField("version", () -> {
            try {
                Manifest manifest = new Manifest(this.getClass().getClassLoader().getResourceAsStream("META-INF/MANIFEST.MF"));
                return manifest.getMainAttributes().getValue("Bundle-Version");
            }
            catch (IOException e) {
                return "---";
            }
        })};
    }
}

