/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.util.macro;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import java.util.Map;

public class RenderInLatestPageContextMacro
extends BaseMacro {
    SubRenderer subRenderer;

    public String execute(Map params, String body, RenderContext renderContext) throws MacroException {
        if (renderContext instanceof PageContext) {
            PageContext pageContext = (PageContext)renderContext;
            ContentEntityObject ceo = pageContext.getEntity();
            if (!ceo.isLatestVersion()) {
                pageContext = ((ContentEntityObject)ceo.getLatestVersion()).toPageContext();
            }
            return this.subRenderer.render(body, (RenderContext)pageContext);
        }
        throw new MacroException("This macro only works on a page context");
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public boolean hasBody() {
        return true;
    }

    public void setSubRenderer(SubRenderer subRenderer) {
        this.subRenderer = subRenderer;
    }
}

