/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.states.macro;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.states.model.Timer;
import com.comalatech.confluence.timers.TimerUtils;
import com.comalatech.confluence.workflow.macros.AbstractWorkflowElementMacro;
import com.comalatech.confluence.workflow.macros.templates.MacroParameters;
import com.opensymphony.util.TextUtils;
import java.util.Map;
import org.joda.time.Period;

public class TimerMacro
extends AbstractWorkflowElementMacro {
    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        Parameters params = new Parameters(parameters, renderContext);
        this.getElementsList(renderContext).add(new Timer(params.name, params.period));
        return "";
    }

    @Override
    public boolean hasBody() {
        return false;
    }

    @Override
    public boolean allowsAnonymousUser() {
        return false;
    }

    public class Parameters
    extends MacroParameters {
        String name;
        Period period;

        public Parameters(Map map, RenderContext renderContext) throws MacroException {
            super(map, renderContext);
            this.name = this.get(new String[]{"name", "0"}, true);
            if (!Timer.isValidName(this.name)) {
                throw new MacroException("Invalid macro name " + this.name);
            }
            String period = this.get("period");
            if (TextUtils.stringSet((String)period)) {
                try {
                    this.period = TimerUtils.parsePeriod(period);
                }
                catch (Exception e) {
                    throw new MacroException(ConfluenceActionSupport.getTextStatic((String)"comalatech.awp.container.workflowparameters.error.invalidperiod", (Object[])new String[]{period}));
                }
            }
        }
    }
}

