/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var requirejs = require || requirejs;
requirejs(['cw', 'jquery', 'ajs'], function(CW, $, AJS) {
    CW.toInit(function () {
        var span = $('.readAckDueDate');
        if (span.length > 0) {
            var userLocale = CW.getParam('userLocale');
            var dateFormat = userLocale && userLocale === 'en_US' ? 'LL' : 'll'; // month first for US locale
            var i;
            for (i=0; i<span.length; i++) {
                var dueDate = span[i].innerHTML;
                var momentDueDate = moment(dueDate, "ddd MMM DD HH:mm:ss YYYY");
                if (momentDueDate.isValid()) {
                    momentDueDate.locale(userLocale);
                    span[i].innerHTML =  momentDueDate.from(moment());
                    $('#readAckDueDate_'+(i+1)).attr('title', momentDueDate.format(dateFormat));
                }
            }
            AJS.$('.readAckDueDate').tooltip();
        }
    });
});
