/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

/**
 * #List
 *   #ApprovalList
 *   #TaskList
 */
var AWP = AWP || {};
AWP.View = AWP.View || {};


AWP.View.List = Backbone.View.extend({
    // backbone prop
    tagName : "ul",
    className: "awp-list",
    // custom prop
    canAssign: false,
    template : AWP.Templates.approversList,
    
    events : {
        "click li" : "nextSlide"
    },

    setTemplate: function (tpl) {
        this.template = tpl;
    },
    
    render: function() {
        this.$el.append(this.template({
            model : this.model
        }));
        
        // direct link approval detected: Open a approval by default, provided by url (approval=ID)
        if(parent && parent.AWP.Embedded) {
            var approvalId = parent.AWP.Embedded.Workflow.getApproval();
            if(approvalId != "" && this.model.get(approvalId)) {
                this.$('#' + approvalId).click();
                
                // reset direct link approval so further clicks on awp icon can behave as usual
                parent.AWP.Embedded.Workflow.setApproval("");
            }
        }
        
        return this;
    },
    
    nextSlide : function(evt) {
        // Get the approvals model data that matches id
        var approval = this.model.get(evt.currentTarget.id);

        AWP.log('List.nextSlide');

        // other slides
        this.dialogSlide = new AWP.View.DialogSlide({
            // slide prop
            model : approval,
            hidden: true,
            caption: approval.get("approver").get("fullName"),
            backCaption: AJS.I18n.getText("adhocworkflows.slide.back", [approval.get("name")]),
            
            // dialog prop
            buttons: this.setActions(approval),
            addnote: true,
            note: ''
        });
        this.dialogSlide.render();
        this.dialogSlide.show();
    },
    
    setActions: function (model) {
        var buttons = {};
        if(model.get("canApprove")) {
            buttons.approve = {"primary": true};
        }
        else {
            buttons.approve = {"primary": false, "readonly": true};
        }
        if(model.get("canReject")) {
            buttons.reject = {"primary": false};
        }
        else {
            buttons.reject = {"primary": false, "readonly": true};
        }
        if(model.get("canUnassign")) {
            buttons.unassign = {"primary": false};
        }
        if(model.get("canDelete")) {
            buttons.remove = {"primary": false};
        }
        
        return buttons;
    }
});

AWP.View.ApprovalList = AWP.View.List.extend({
    template: AWP.Templates.approvalsList,

    nextSlide : function(evt) {
        // Get the approvals model data that matches id
        var approval = this.model.get(evt.currentTarget.id);
        
        AWP.log('ApprovalList.nextSlide', approval);

        // The approval requires various approvers, show list
        if (approval.get("approvers").size() > 0) {
            try {
                this.approversSlide.remove();
            }
            catch(e) {}
            
            var caption = approval.get("name");
            this.approversSlide = new AWP.View.ApproverSlide({
                model : approval,
                hidden: true,
                caption: caption
            });
            
            this.approversSlide.render();
            this.approversSlide.show();
            
            
        // Show the dialog view the approve-reject
        } else {
            var caption = approval.get("name");
            this.dialogSlide = new AWP.View.DialogSlide({
                // slide prop
                model : approval,
                hidden: true,
                caption: caption,
                
                // dialog prop
                buttons: this.setActions(approval),
                addnote: true,
                note: ''
            });
            
            this.dialogSlide.render();
            this.dialogSlide.show();
        }
    },
    
    setActions: function (approval) {
        var buttons = {};
        if(approval.get("canApprove")) {
            buttons.approve = {"primary": true};
        }
        else {
            buttons.approve = {"primary": false, "readonly": true};
        }
        if(approval.get("canReject")) {
            buttons.reject = {"primary": false};
        }
        else {
            buttons.reject = {"primary": false, "readonly": true};
        }
        
        return buttons;
    }
});

AWP.View.TaskList = AWP.View.List.extend({
    tagName:  "li",
    className: "",
    
    template: AWP.Templates.taskItem,

    events : {
        "click" : "nextSlide"
    },
    
    buttons: {
        "complete": {"primary": true},
        "remove": {"primary": false}
    },

    initialize: function () {
        this.model.on('change', _.bind(this.render, this));
    },
    
    arrangeName: function () {
        var title = this.model.get('name');
        // format username
        title = title.replace(this.model.get('assigneeName'), this.model.get('assigneeFullName'));
        this.model.set('name', ' ' + title, {silent:true});
    },

    render: function() {
        this.arrangeName();
        
        this.$el.html(this.template({
            model : this.model,
            highlight: this.model.get('assigneeName') && (this.model.get('assigneeName') == parent.AJS.params.remoteUser)
        }));
        
        // tasks completed
        if(this.model.get("completed")) {
            this.$el.addClass("completed");
        }
        
        // direct link task detected: Open a task by default, provided by url (task=ID)
        if(parent && parent.AWP.Embedded) {
            var taskId = parent.AWP.Embedded.Workflow.getTask();
            if(taskId !== "" && ("task-" + taskId) === this.model.id) {
                this.$el.click();
                
                // reset direct link task so further clicks on awp icon can behave as usual
                parent.AWP.Embedded.Workflow.setTask("");
            }
        }
        return this;
    },
    
    nextSlide: function() {
        AWP.log("TaskList.nextSlide: ", this.model);
        
        // other slides
        this.dialogSlide = new AWP.View.TaskDialogSlide({
            // slide prop
            model : this.model,
            hidden: true,
            caption: this.model.get("name"),
            backCaption: AJS.I18n.getText("adhocworkflows.slide.back.tasks"),
            
            // dialog prop
            buttons: this.setActions(this.model),
            addnote: !this.model.get("completed"),
            note: this.model.get("note")
        });
        this.dialogSlide.render();
        this.dialogSlide.show();

        // editable task note
        var editables = new AWP.View.Editable({
            model: this.model
        });
        editables.init('editable');
    },
    
    setActions: function (model) {
        var buttons = {};
        
        if(model.get("canComplete")) {
            buttons.complete = {"primary": true};
        }
        if(model.get("canDelete")) {
            buttons.remove = {"primary": false};
        }
        
        return buttons;
    }
});