/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.service;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.TermRangeQuery;
import com.comalatech.confluence.states.model.Timer;
import com.comalatech.confluence.workflow.model.WorkflowsSearchConfluence8CompatibilityBuilder;
import com.comalatech.confluence.workflow.service.ApprovalsSearchService;
import com.comalatech.confluence.workflowreports.model.WorkflowReportOptions;
import com.comalatech.confluence.workflowreports.search.LuceneHelper;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApprovalsSearchServiceImpl
implements ApprovalsSearchService {
    private static final Logger log = LoggerFactory.getLogger(ApprovalsSearchServiceImpl.class);
    private static final int DOCS_PER_BATCH = 100;
    private final SearchManager searchManager;
    private final PageManager pageManager;

    public ApprovalsSearchServiceImpl(SearchManager searchManager, PageManager pageManager) {
        this.searchManager = searchManager;
        this.pageManager = pageManager;
    }

    @Override
    public List<String> getSpaceStates(String spaceKey) {
        if (TextUtils.stringSet((String)spaceKey)) {
            return this.getVector(LuceneHelper.makeStatesVectorKey(spaceKey), 1);
        }
        return this.getVector(LuceneHelper.getStatesVectorKey(), 1);
    }

    @Override
    public List<String> getFilteredSpaceStates(WorkflowReportOptions options) {
        List<String> fullStatesList = this.getVector(LuceneHelper.makeStatesVectorKey(options.getSpaceKey()), 1);
        HashSet states = new HashSet();
        for (String pageState : options.getStateNames()) {
            fullStatesList.stream().filter(s -> pageState.trim().equalsIgnoreCase((String)s)).findFirst().ifPresent(states::add);
        }
        return new ArrayList<String>(states);
    }

    @Override
    public List<String> getSpaceAssignees(String spaceKey) {
        return this.getVector(LuceneHelper.makeAssigneesVectorKey(spaceKey), 0);
    }

    @Override
    public boolean hasStates(String spaceKey) {
        String fieldName = LuceneHelper.makeStatesVectorKey(spaceKey);
        return this.fieldExists(fieldName);
    }

    @Override
    public boolean hasDueDate(String spaceKey) {
        String fieldName = LuceneHelper.makeTimersVectorKey(spaceKey);
        SearchQuery query = (SearchQuery)BooleanQuery.builder().addMust((Object)WorkflowsSearchConfluence8CompatibilityBuilder.getFieldExistsQuery(fieldName)).build();
        ISearch search = this.createSearchObject(10, query);
        try {
            List results = this.searchManager.search(search, null).getAll();
            if (results == null) {
                return false;
            }
            for (SearchResult result : results) {
                if (!Timer.DUE_DATE_TIMERNAME.equalsIgnoreCase(LuceneHelper.unmaskSpaces(result.getField(fieldName)))) continue;
                return true;
            }
        }
        catch (InvalidSearchException e) {
            log.error("Error searching for index field: " + fieldName + "in space " + spaceKey, (Throwable)e);
            String errorMessage = ConfluenceActionSupport.getTextStatic((String)"com.comalatech.workflow.lucene.getFieldVectorError", (Object[])new Object[]{fieldName});
            throw new RuntimeException(errorMessage);
        }
        return false;
    }

    @Override
    public boolean hasTasks(String spaceKey) {
        return this.fieldExists("hastasks");
    }

    @Override
    public List<AbstractPage> getExpiredPages(Date dueDate, int batchSize) {
        Set<String> handles;
        TermRangeQuery query = new TermRangeQuery("earliestDueDate", "0", LuceneHelper.luceneDateToSeconds(dueDate), false, true);
        ISearch search = this.createSearchObject(batchSize > 0 ? batchSize : 100, (SearchQuery)query);
        try {
            handles = this.searchManager.search(search, null).getAll().stream().filter(Objects::nonNull).map(res -> res.getHandle().toString()).collect(Collectors.toSet());
        }
        catch (InvalidSearchException e) {
            log.error("Error getting expired pages", (Throwable)e);
            throw new RuntimeException(e);
        }
        return this.getPages(handles);
    }

    @Override
    public int getNumberOfPagesWithWorkflow() {
        SearchQuery query = (SearchQuery)BooleanQuery.builder().addMust((Object)WorkflowsSearchConfluence8CompatibilityBuilder.getFieldExistsQuery("awpadhocworkflowctec")).build();
        ISearch search = this.createSearchObject(10, query);
        try {
            return this.searchManager.search(search, null).getUnfilteredResultsCount();
        }
        catch (InvalidSearchException e) {
            log.error("Error getting the count of awpadhocworkflowctec", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getNumberOfSpacesWithWorkflow() {
        int count;
        SearchQuery query = (SearchQuery)BooleanQuery.builder().addMust((Object)WorkflowsSearchConfluence8CompatibilityBuilder.getFieldExistsQuery("awpadhocworkflowspaces")).build();
        ISearch search = this.createSearchObject(10, query);
        try {
            HashSet spaces = new HashSet();
            this.searchManager.search(search, null).getAll().forEach(result -> spaces.add(result.getField("awpadhocworkflowspaces")));
            count = spaces.size();
        }
        catch (InvalidSearchException e) {
            log.error("Error getting the count of awpadhocworkflowspaces", (Throwable)e);
            throw new RuntimeException(e);
        }
        return count;
    }

    private List<String> getVector(String fieldName, int ignoredChars) {
        ArrayList<String> allNames = new ArrayList<String>();
        SearchQuery query = (SearchQuery)BooleanQuery.builder().addMust((Object)WorkflowsSearchConfluence8CompatibilityBuilder.getFieldExistsQuery(fieldName)).build();
        ISearch search = this.createSearchObject(10, query);
        try {
            this.searchManager.search(search, null).getAll().forEach(result -> {
                String indexedText = result.getField(fieldName);
                if (TextUtils.stringSet((String)indexedText)) {
                    for (String indexedState : indexedText.split("\\s")) {
                        String state;
                        if (indexedState.length() <= ignoredChars || allNames.contains(state = LuceneHelper.unmaskSpaces(indexedState.substring(ignoredChars)))) continue;
                        allNames.add(state);
                    }
                }
            });
        }
        catch (InvalidSearchException e) {
            log.error("Error getting the count of " + fieldName, (Throwable)e);
            throw new RuntimeException(e);
        }
        return allNames;
    }

    private boolean fieldExists(String fieldName) {
        SearchQuery query = (SearchQuery)BooleanQuery.builder().addMust((Object)WorkflowsSearchConfluence8CompatibilityBuilder.getFieldExistsQuery(fieldName)).build();
        ISearch search = this.createSearchObject(10, query);
        try {
            return this.searchManager.search(search, null).getUnfilteredResultsCount() > 0;
        }
        catch (InvalidSearchException e) {
            log.error("Error checking existence of " + fieldName, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private List<AbstractPage> getPages(Set<String> handles) {
        ArrayList<AbstractPage> pages = new ArrayList<AbstractPage>(handles.size());
        for (String handle : handles) {
            try {
                long id = Long.parseLong(handle.substring(handle.lastIndexOf("-") + 1));
                AbstractPage page = this.pageManager.getAbstractPage(id);
                if (page == null || page.isDeleted()) continue;
                pages.add(page);
            }
            catch (Exception e) {
                log.warn("invalid handle :" + handle);
            }
        }
        return pages;
    }

    private ISearch createSearchObject(int limit, SearchQuery query) {
        return WorkflowsSearchConfluence8CompatibilityBuilder.getContentSearch(query, null, 0, limit);
    }
}

