/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.rest.expander.content;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.states.model.StateSelection;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.StateSelectionManager;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.rest.expander.content.AbstractWorkflowActionExpander;
import com.comalatech.confluence.workflow.rest.model.ContentState;
import com.comalatech.confluence.workflow.rest.model.ContentWorkflowRequest;
import com.comalatech.confluence.workflow.rest.model.ContentWorkflowResponse;
import com.comalatech.confluence.workflow.rest.model.State;
import com.comalatech.workflow.model.PageStatus;
import com.comalatech.workflow.model.PageWorkflowParameter;
import com.opensymphony.util.TextUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class StateExpander
extends AbstractWorkflowActionExpander {
    public static final String EXPANDER = "state";
    protected final WorkflowAccessor workflowAccessor;
    private final StateSelectionManager stateSelectionManager;

    public StateExpander(WorkflowAccessor workflowAccessor, StateSelectionManager stateSelectionManager) {
        super(EXPANDER);
        this.workflowAccessor = workflowAccessor;
        this.stateSelectionManager = stateSelectionManager;
    }

    @Override
    public void expand(ContentWorkflowResponse response, ContentWorkflowRequest request) {
        PageStatus pageStatus = request.getWorkflowAction().getPageStatus();
        ContentState state = new ContentState(pageStatus.getStateName(), pageStatus.getStateDescription(), false, pageStatus.isFinalState(), this.convertDate(pageStatus.getExpirationDateValue()), pageStatus.getStateColour(), pageStatus.isHideStates(), pageStatus.isTaskable(), pageStatus.isChangeExpirationDate());
        Map<String, List<PageWorkflowParameter>> parameters = request.getWorkflowAction().params;
        AbstractPage page = request.getPage();
        PageWorkflows workflows = this.workflowAccessor.getPageWorkflows(page);
        if (workflows != null && workflows.getStatesContainer() != null) {
            StateSelection selection;
            State workflowsState = workflows.getStatesContainer().getState(pageStatus.getStateName());
            if (workflowsState != null) {
                state.transitions = new State.StateTransitions(workflowsState, parameters);
            }
            PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
            if (request.isAdmin() && pageWorkflows.getValueStore().canAdminWorkflow(AuthenticatedUserThreadLocal.get()) && (selection = this.stateSelectionManager.getStatesSelection(pageWorkflows, true)) != null) {
                for (State allowedState : selection.getAllowedStates()) {
                    state.transitions.select.add(State.StateTransition.of(allowedState.getName(), parameters));
                }
            }
        }
        response.state = state;
        if (TextUtils.stringSet((String)pageStatus.getPublishedStateName())) {
            ContentState publishedState;
            response.publishedState = publishedState = new ContentState(pageStatus.getPublishedStateName(), pageStatus.getPublishedStateDescription(), false, true, null, pageStatus.getPublishedStateColour(), false, false, false);
        }
    }

    protected Long convertDate(String date) {
        if (!TextUtils.stringSet((String)date)) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date d = dateFormat.parse(date);
            return d.getTime();
        }
        catch (ParseException e) {
            return null;
        }
    }
}

