/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.macros;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostCreateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostUpdateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentCreateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentRemoveEvent;
import com.atlassian.confluence.event.events.content.comment.CommentUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageMoveEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.event.events.label.LabelAddEvent;
import com.atlassian.confluence.event.events.label.LabelRemoveEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageUpdateTrigger;
import com.atlassian.confluence.plugins.inlinecomments.events.InlineCommentCreateEvent;
import com.atlassian.confluence.plugins.inlinecomments.events.InlineCommentResolveEvent;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.events.PdfExportErrorEvent;
import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.events.PdfExportSuccessEvent;
import com.comalatech.confluence.readack.events.ReadAckCompletedEventImpl;
import com.comalatech.confluence.readack.events.ReadAckCreatedEventImpl;
import com.comalatech.confluence.readack.events.ReadAckOverdueEventImpl;
import com.comalatech.confluence.readack.events.ReadAcknowledgedEventImpl;
import com.comalatech.confluence.states.event.BlogPostStateTransitionEvent;
import com.comalatech.confluence.states.event.DummyTaskAssignEvent;
import com.comalatech.confluence.states.event.DummyTaskCompleteEvent;
import com.comalatech.confluence.states.event.DummyTaskCreateEvent;
import com.comalatech.confluence.states.event.DummyTaskDueDateExpiredEvent;
import com.comalatech.confluence.states.event.PageStateTransitionEvent;
import com.comalatech.confluence.states.event.StateExpireEvent;
import com.comalatech.confluence.states.event.StateExpiryUpdatedEvent;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.events.BlogPostApprovalApproveEvent;
import com.comalatech.confluence.workflow.events.BlogPostApprovalAssignedEvent;
import com.comalatech.confluence.workflow.events.BlogPostApprovalRejectEvent;
import com.comalatech.confluence.workflow.events.DefaultApprovalDueDateExpiredEvent;
import com.comalatech.confluence.workflow.events.DefaultApprovalUnassignedEvent;
import com.comalatech.confluence.workflow.events.PageApprovalApproveEvent;
import com.comalatech.confluence.workflow.events.PageApprovalAssignedEvent;
import com.comalatech.confluence.workflow.events.PageApprovalRejectEvent;
import com.comalatech.confluence.workflow.events.WorkflowAttachmentChangedEvent;
import com.comalatech.confluence.workflow.events.WorkflowAttachmentCreateEvent;
import com.comalatech.confluence.workflow.events.WorkflowAttachmentRemoveEvent;
import com.comalatech.confluence.workflow.events.WorkflowAttachmentUpdateEvent;
import com.comalatech.confluence.workflow.events.WorkflowAttachmentVersionRemoveEvent;
import com.comalatech.confluence.workflow.events.WorkflowCustomEvent;
import com.comalatech.confluence.workflow.events.WorkflowPageParameterUpdatedEventImpl;
import com.comalatech.confluence.workflow.macros.AbstractWorkflowElementMacro;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.model.Condition;
import com.comalatech.confluence.workflow.model.StateInitializedCondition;
import com.comalatech.confluence.workflow.model.Trigger;
import com.comalatech.confluence.workflow.model.WorkflowElement;
import com.comalatech.confluence.workflow.model.WorkflowParameter;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;

public class TriggerMacro
extends AbstractWorkflowElementMacro {
    public static final String PARAM_LABEL = "label";
    public static final String PARAM_ADDED_LABEL = "addedlabel";
    public static final String PARAM_REMOVED_LABEL = "removedlabel";
    public static final String PARAM_APPROVAL = "approval";
    public static final String PARAM_QUEUE = "queue";
    public static final String PARAM_NEWEVENT = "newevent";
    public static final String PARAM_SUCCESS = "success";
    public static final String PARAM_PARTIAL = "partial";
    public static final String PARAM_INITIAL = "initial";
    public static final String PARAM_TASK = "task";
    public static final String PARAM_PARAMETER = "parameter";
    public static final RenderMode RENDER_MODE = RenderMode.allow((long)17412L);
    public static final String PARAM_DESCRIPTION = "description";
    private SubRenderer subRenderer;

    private Map<String, String> makeMacroParams(String eventName) {
        HashMap<String, String> macroParams = new HashMap<String, String>();
        macroParams.put(PARAM_LABEL, null);
        macroParams.put(PARAM_REMOVED_LABEL, null);
        macroParams.put(PARAM_ADDED_LABEL, null);
        macroParams.put(PARAM_APPROVAL, null);
        macroParams.put(PARAM_QUEUE, null);
        macroParams.put(PARAM_NEWEVENT, null);
        macroParams.put(PARAM_SUCCESS, null);
        macroParams.put(PARAM_PARTIAL, null);
        macroParams.put(PARAM_INITIAL, null);
        macroParams.put(PARAM_TASK, null);
        macroParams.put(PARAM_PARAMETER, null);
        macroParams.put(PARAM_DESCRIPTION, null);
        if (eventName.contains("statechanged")) {
            macroParams.put("state", null);
        }
        return macroParams;
    }

    @Override
    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    @Override
    public boolean allowsAnonymousUser() {
        return true;
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        String approvalName;
        Object event;
        String labelName;
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        String eventName = this.getParam(parameters, "0");
        if (!TextUtils.stringSet((String)eventName)) {
            throw new MacroException("must define an event in the trigger");
        }
        eventName = eventName.trim();
        Map<String, String> macroParams = this.makeMacroParams(eventName);
        ArrayList flags = new ArrayList();
        this.parseParameters(parameters, conditions, flags, macroParams, null);
        List<WorkflowElement> elements = this.getElementsList(renderContext);
        Page dummyPage = new Page();
        BlogPost dummyBlogPost = new BlogPost();
        boolean partial = Boolean.TRUE.toString().equals(parameters.get(PARAM_PARTIAL));
        String description = null;
        if (parameters.get(PARAM_DESCRIPTION) != null) {
            description = parameters.get(PARAM_DESCRIPTION).toString();
        }
        if (eventName.equals("labeladded")) {
            labelName = TextUtils.stringSet((String)macroParams.get(PARAM_ADDED_LABEL)) ? macroParams.get(PARAM_ADDED_LABEL) : macroParams.get(PARAM_LABEL);
            event = new LabelAddEvent(TriggerMacro.parseLabelNullAllowed(labelName), null);
            if (macroParams.get(PARAM_INITIAL) != null) {
                conditions.add(new StateInitializedCondition(false, macroParams.get(PARAM_INITIAL)));
            }
        } else if (eventName.equals("labelremoved")) {
            labelName = TextUtils.stringSet((String)macroParams.get(PARAM_REMOVED_LABEL)) ? macroParams.get(PARAM_REMOVED_LABEL) : macroParams.get(PARAM_LABEL);
            event = new LabelRemoveEvent(TriggerMacro.parseLabelNullAllowed(labelName), null);
        } else if (eventName.equals("pageapproved")) {
            approvalName = this.getApprovalName(macroParams);
            event = new PageApprovalApproveEvent((Object)this, dummyPage, null, new ApprovalCheck(approvalName), partial);
        } else if (eventName.equals("pagerejected")) {
            approvalName = this.getApprovalName(macroParams);
            event = new PageApprovalRejectEvent((Object)this, dummyPage, null, new ApprovalCheck(approvalName), partial);
        } else if (eventName.equals("pagecreated")) {
            event = new PageCreateEvent((Object)this, dummyPage);
        } else if (eventName.equals("pageupdated")) {
            event = new PageUpdateEvent((Object)this, dummyPage, null, false, PageUpdateTrigger.UNKNOWN);
        } else if (eventName.equals("pagemoved")) {
            event = new PageMoveEvent((Object)this, new Page(), new ArrayList(), new Space(), null, null, null, false);
        } else if (eventName.equals("newscreated")) {
            event = new BlogPostCreateEvent((Object)this, dummyBlogPost);
        } else if (eventName.equals("newsupdated")) {
            event = new BlogPostUpdateEvent((Object)this, dummyBlogPost, null);
        } else if (eventName.equals("newsapproved")) {
            approvalName = this.getApprovalName(macroParams);
            event = new BlogPostApprovalApproveEvent((Object)this, dummyBlogPost, null, new ApprovalCheck(approvalName), partial);
        } else if (eventName.equals("newsrejected")) {
            approvalName = this.getApprovalName(macroParams);
            event = new BlogPostApprovalRejectEvent((Object)this, dummyBlogPost, null, new ApprovalCheck(approvalName), partial);
        } else if (eventName.equals("statechanged") || eventName.equals("pagestatechanged")) {
            PageStateTransitionEvent stateEvent = new PageStateTransitionEvent((Object)this, dummyPage, null, new PageState(this.getStateName(macroParams)));
            stateEvent.setSourceEvent(eventName);
            if (macroParams.get(PARAM_INITIAL) != null) {
                conditions.add(new StateInitializedCondition(false, macroParams.get(PARAM_INITIAL)));
                stateEvent.setInitial("true".equalsIgnoreCase(macroParams.get(PARAM_INITIAL)));
            }
            event = stateEvent;
        } else if (eventName.equals("stateexpired")) {
            event = new StateExpireEvent((Object)this, null, new PageState(this.getStateName(parameters)), null);
        } else if (eventName.equals("stateexpiryupdated")) {
            event = new StateExpiryUpdatedEvent((Object)this, null, new PageState(this.getStateName(parameters)));
        } else if (eventName.equals("newsstatechanged")) {
            event = new BlogPostStateTransitionEvent((Object)this, dummyBlogPost, null, new PageState(this.getStateName(macroParams)));
        } else if (eventName.equals("attachmentadded")) {
            event = new WorkflowAttachmentCreateEvent((Object)this, null, null);
        } else if (eventName.equals("attachmentremoved")) {
            event = new WorkflowAttachmentRemoveEvent((Object)this, null, null);
        } else if (eventName.equals("attachmentversionremoved")) {
            event = new WorkflowAttachmentVersionRemoveEvent((Object)this, null, null);
        } else if (eventName.equals("attachmentupdated")) {
            event = new WorkflowAttachmentUpdateEvent((Object)this, null, null);
        } else if (eventName.equals("attachmentschanged")) {
            event = new WorkflowAttachmentChangedEvent((Object)this, null, null);
        } else if (eventName.equals("pageapprovalassigned")) {
            approvalName = this.getApprovalName(macroParams);
            event = new PageApprovalAssignedEvent((Object)this, dummyPage, null, new ApprovalCheck(approvalName), false, null, null);
        } else if (eventName.equals("newsapprovalassigned")) {
            approvalName = this.getApprovalName(macroParams);
            event = new BlogPostApprovalAssignedEvent((Object)this, dummyBlogPost, null, new ApprovalCheck(approvalName), false, null, null);
        } else if (eventName.equals("approvalunassigned")) {
            approvalName = this.getApprovalName(macroParams);
            event = new DefaultApprovalUnassignedEvent((Object)this, new ApprovalCheck(approvalName), null, null, false, null);
        } else if (eventName.equals("approvalexpired")) {
            approvalName = this.getApprovalName(macroParams);
            event = new DefaultApprovalDueDateExpiredEvent((Object)this, new ApprovalCheck(approvalName), null, null, false);
        } else if (eventName.equals("taskassigned")) {
            event = new DummyTaskAssignEvent(this.getTaskName(macroParams));
        } else if (eventName.equals("taskcreated")) {
            event = new DummyTaskCreateEvent(this.getTaskName(macroParams));
        } else if (eventName.equals("taskcompleted")) {
            event = new DummyTaskCompleteEvent(this.getTaskName(macroParams));
        } else if (eventName.equals("taskexpired")) {
            event = new DummyTaskDueDateExpiredEvent(this.getTaskName(macroParams));
        } else if (eventName.equals("pageparameterupdate")) {
            event = new WorkflowPageParameterUpdatedEventImpl((Object)this, (AbstractPage)dummyPage, null, this.getWorkflowParameter(macroParams));
        } else if (eventName.equals("pagecommentcreated")) {
            event = new CommentCreateEvent((Object)this, new Comment());
        } else if (eventName.equals("pagecommentremoved")) {
            event = new CommentRemoveEvent((Object)this, new Comment(), null);
        } else if (eventName.equals("pagecommentupdated")) {
            event = new CommentUpdateEvent((Object)this, new Comment());
        } else if (eventName.equals("inlinecommentcreated")) {
            event = new InlineCommentCreateEvent((Object)this, new Comment());
        } else if (eventName.equals("inlinecommentresolved")) {
            event = new InlineCommentResolveEvent((Object)this, new Comment());
        } else if (this.findCustomTrigger(elements, eventName) != null) {
            String successparam = (String)parameters.get(PARAM_SUCCESS);
            boolean success = successparam == null || successparam.equals(Boolean.TRUE.toString());
            event = new WorkflowCustomEvent((Object)this, null, eventName, success, null);
        } else if (eventName.equals("confirmationcompleted")) {
            event = new ReadAckCompletedEventImpl((Object)this, null, null, null);
        } else if (eventName.equals("confirmationrequested")) {
            event = new ReadAckCreatedEventImpl((Object)this, null, null);
        } else if (eventName.equals("confirmationdue")) {
            event = new ReadAckOverdueEventImpl((Object)this, null);
        } else if (eventName.equals("confirmationacknowledged")) {
            event = new ReadAcknowledgedEventImpl((Object)this, null);
        } else if (eventName.equals("pdf-export-success")) {
            event = new PdfExportSuccessEvent((Object)this, (AbstractPage)dummyPage, null, null);
        } else if (eventName.equals("pdf-export-error")) {
            event = new PdfExportErrorEvent((Object)this, (AbstractPage)dummyPage, null, "");
        } else {
            throw new MacroException("Invalid event name " + eventName);
        }
        boolean queue = Boolean.TRUE.toString().equals(parameters.get(PARAM_QUEUE));
        Trigger trigger = new Trigger((ConfluenceEvent)event, true, eventName, conditions, body, queue, (String)parameters.get(PARAM_NEWEVENT), description);
        elements.add(trigger);
        String message = this.subRenderer.render(body, renderContext, RENDER_MODE).trim();
        if (this.hasError(message)) {
            return message;
        }
        try {
            trigger.validate();
        }
        catch (WorkflowException e) {
            throw new MacroException(e.getMessage());
        }
        return "";
    }

    private Trigger findCustomTrigger(List elements, String name) {
        for (Object o : elements) {
            Trigger trigger;
            if (!(o instanceof Trigger) || !name.equals((trigger = (Trigger)o).getNewEvent())) continue;
            return trigger;
        }
        return null;
    }

    private String getApprovalName(Map<String, String> macroParams) throws MacroException {
        String approvalName = macroParams.get(PARAM_APPROVAL);
        if (!TextUtils.stringSet((String)approvalName)) {
            throw new MacroException(ConfluenceActionSupport.getTextStatic((String)"com.comalatech.confluence.workflow.macros.triggerMacro.approvalNameException"));
        }
        return approvalName;
    }

    private String getStateName(Map<String, String> macroParams) throws MacroException {
        String stateName = macroParams.get("state");
        if (!TextUtils.stringSet((String)stateName)) {
            throw new MacroException(ConfluenceActionSupport.getTextStatic((String)"com.comalatech.confluence.workflow.macros.triggerMacro.stateException"));
        }
        return stateName;
    }

    private WorkflowParameter getWorkflowParameter(Map<String, String> macroParams) throws MacroException {
        String paramName = macroParams.get(PARAM_PARAMETER);
        if (!TextUtils.stringSet((String)paramName)) {
            throw new MacroException(ConfluenceActionSupport.getTextStatic((String)"com.comalatech.confluence.workflow.macros.triggerMacro.paramException"));
        }
        return new WorkflowParameter(paramName, "", null, "", "", true);
    }

    private String getTaskName(Map macroParams) {
        return MapUtils.getString(macroParams, PARAM_TASK);
    }

    @Override
    public void setSubRenderer(SubRenderer subRenderer) {
        this.subRenderer = subRenderer;
    }
}

