/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.accesor;

import com.atlassian.confluence.persistence.EntityManagerProvider;
import com.comalatech.confluence.workflow.accesor.WorkflowsActivityRecordAccessor;
import com.comalatech.confluence.workflow.accesor.entity.PageActivityRecord;
import com.comalatech.confluence.workflow.accesor.entity.WorkflowActivityRecord;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;

public class WorkflowsActivityRecordAccessorImpl
implements WorkflowsActivityRecordAccessor {
    private final EntityManagerProvider entityManagerProvider;
    private static final String WORKFLOW_ACTIVITY_KEY = "com.comalatech.states";
    private static final String READ_ACK_ACTIVITY_KEY = "com.comalatech.readack.activities";

    public WorkflowsActivityRecordAccessorImpl(EntityManagerProvider entityManagerProvider) {
        this.entityManagerProvider = entityManagerProvider;
    }

    @Override
    public List<WorkflowActivityRecord> findAllWorkflowActivity() {
        TypedQuery query = this.entityManagerProvider.getEntityManager().createQuery("select count(propertySet.entityId) as NUM_PAGES, content.space.id as SPACE_ID from BucketPropertySetItem propertySet, ContentEntityObject content where (propertySet.key = :states_key or (propertySet.key = :read_key and propertySet.entityId not in (select propertySetAux.entityId from BucketPropertySetItem propertySetAux where propertySetAux.key = :states_key))) and propertySet.entityId = content.id and content.space.id is not null group by content.space.id order by NUM_PAGES desc", Tuple.class);
        query.setParameter("states_key", (Object)WORKFLOW_ACTIVITY_KEY);
        query.setParameter("read_key", (Object)READ_ACK_ACTIVITY_KEY);
        List workflowActivityItems = query.getResultList();
        return workflowActivityItems.stream().map(record -> new WorkflowActivityRecord((Long)record.get("NUM_PAGES"), (Long)record.get("SPACE_ID"))).collect(Collectors.toList());
    }

    @Override
    public List<PageActivityRecord> findAllWorkflowActivityBySpace(Long spaceId) {
        TypedQuery query = this.entityManagerProvider.getEntityManager().createQuery("select propertySet.entityId as CONTENT_ID from BucketPropertySetItem propertySet, ContentEntityObject content where (propertySet.key = :states_key or (propertySet.key = :read_key and propertySet.entityId not in (select propertySetAux.entityId from BucketPropertySetItem propertySetAux where propertySetAux.key = :states_key))) and propertySet.entityId = content.id and content.space.id = :space_id", Tuple.class);
        query.setParameter("states_key", (Object)WORKFLOW_ACTIVITY_KEY);
        query.setParameter("read_key", (Object)READ_ACK_ACTIVITY_KEY);
        query.setParameter("space_id", (Object)spaceId);
        List pageWorkflowActivityItems = query.getResultList();
        return pageWorkflowActivityItems.stream().map(record -> new PageActivityRecord((Long)record.get("CONTENT_ID"), spaceId)).collect(Collectors.toList());
    }
}

