/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.upgrade.manager;

import com.atlassian.confluence.api.model.longtasks.LongTaskId;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.user.User;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.PreCheck;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.PreCheckStatus;
import com.comalatech.confluence.documentActivity.upgrade.manager.SpaceUpgradeManager;
import com.comalatech.confluence.documentActivity.upgrade.service.DocumentActivityUpgradeService;
import com.comalatech.confluence.documentActivity.upgrade.tasks.SpaceUpgradeTask;
import com.comalatech.confluence.documentActivity.usecases.contracts.GenerateDocumentActivity;
import com.comalatech.confluence.documentActivity.usecases.contracts.ValidateDocumentActivity;
import com.comalatech.confluence.util.ReadWriteTransactionService;
import com.comalatech.confluence.workflow.accesor.WorkflowsActivityRecordAccessor;
import com.comalatech.confluence.workflow.accesor.entity.PageActivityRecord;
import com.comalatech.confluence.workflow.analytics.UpgradeStatsGatherer;
import com.comalatech.confluence.workflow.supportconsole.infrastructure.contract.SupportPresenter;
import com.comalatech.confluence.workflow.user.WorkflowAuthenticatedUserThreadLocal;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceUpgradeManagerImpl
implements SpaceUpgradeManager {
    private static final Logger log = LoggerFactory.getLogger(SpaceUpgradeManagerImpl.class);
    private final DocumentActivityUpgradeService documentActivityUpgradeService;
    private final LongRunningTaskManager longRunningTaskManager;
    private final WorkflowsActivityRecordAccessor workflowsActivityAccessor;
    private final ValidateDocumentActivity validateDocumentActivity;
    private final GenerateDocumentActivity generateDocumentActivity;
    private final PageManager pageManager;
    private final ReadWriteTransactionService readWriteTransactionService;
    private final SupportPresenter templateFileLayoutHelper;
    private final UpgradeStatsGatherer upgradeStatsGatherer;

    public SpaceUpgradeManagerImpl(DocumentActivityUpgradeService documentActivityUpgradeService, LongRunningTaskManager longRunningTaskManager, WorkflowsActivityRecordAccessor workflowsActivityAccessor, ValidateDocumentActivity validateDocumentActivity, GenerateDocumentActivity generateDocumentActivity, PageManager pageManager, ReadWriteTransactionService readWriteTransactionService, SupportPresenter templateFileLayoutHelper, UpgradeStatsGatherer upgradeStatsGatherer) {
        this.documentActivityUpgradeService = documentActivityUpgradeService;
        this.longRunningTaskManager = longRunningTaskManager;
        this.workflowsActivityAccessor = workflowsActivityAccessor;
        this.validateDocumentActivity = validateDocumentActivity;
        this.generateDocumentActivity = generateDocumentActivity;
        this.pageManager = pageManager;
        this.readWriteTransactionService = readWriteTransactionService;
        this.templateFileLayoutHelper = templateFileLayoutHelper;
        this.upgradeStatsGatherer = upgradeStatsGatherer;
    }

    @Override
    public PreCheck launchSpacePreCheckTask(Space space) {
        PreCheck preCheck = this.documentActivityUpgradeService.getSpacePreCheck(space);
        if (preCheck == null) {
            preCheck = new PreCheck();
        } else {
            switch (preCheck.getStatus()) {
                case IN_PROGRESS: {
                    String taskId = preCheck.getLongRunningTaskId();
                    LongRunningTaskId longRunningTaskId = LongRunningTaskId.from((LongTaskId)LongTaskId.deserialise((String)taskId));
                    LongRunningTask longRunningTask = this.longRunningTaskManager.getLongRunningTask((User)WorkflowAuthenticatedUserThreadLocal.get(), longRunningTaskId);
                    if (longRunningTask == null) {
                        preCheck.setStatus(PreCheckStatus.FAIL);
                        this.documentActivityUpgradeService.saveSpacePreCheck(space, preCheck);
                        log.error("There is no long running task in progress for the space pre-check:" + space.getKey());
                    }
                    return preCheck;
                }
            }
        }
        List<PageActivityRecord> pageActivityRecords = this.workflowsActivityAccessor.findAllWorkflowActivityBySpace(space.getId());
        SpaceUpgradeTask preCheckTask = new SpaceUpgradeTask(space, preCheck, pageActivityRecords, this.documentActivityUpgradeService, this.validateDocumentActivity, this.generateDocumentActivity, this.pageManager, this.readWriteTransactionService, this.templateFileLayoutHelper, this.upgradeStatsGatherer, false);
        LongRunningTaskId longRunningTaskId = this.longRunningTaskManager.startLongRunningTask((User)WorkflowAuthenticatedUserThreadLocal.get(), (LongRunningTask)preCheckTask);
        if (longRunningTaskId != null) {
            preCheck = this.initPreCheckTaskProperties();
            preCheck.setLongRunningTaskId(longRunningTaskId.asLongTaskId().serialise());
            this.documentActivityUpgradeService.saveSpacePreCheck(space, preCheck);
        } else {
            log.debug("Space upgrades pre-check task did not start, no long running task id was identified for the space pre-check:" + space.getKey());
        }
        return preCheck;
    }

    @Override
    public void cancelSpacePreCheckTask(Space space) {
        this.documentActivityUpgradeService.saveSpacePreCheck(space, this.stopPreCheckTaskProperties());
    }

    private PreCheck initPreCheckTaskProperties() {
        return new PreCheck(PreCheckStatus.IN_PROGRESS, DateTime.now().getMillis(), null, null, 0, null, null);
    }

    private PreCheck stopPreCheckTaskProperties() {
        return new PreCheck(PreCheckStatus.CANCEL, null, null, null, null, null, null);
    }
}

