/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.ao.accesor.builder;

import com.comalatech.confluence.documentActivity.ao.accesor.builder.FilterBuilder;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityActionTypesFilter;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityQuery;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityQueryFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.java.ao.Query;

public class TypesFilterBuilder
implements FilterBuilder {
    @Override
    public Query build(DocumentActivityQuery query) {
        List<DocumentActivityActionTypesFilter> types;
        ArrayList<String> values = new ArrayList<String>();
        DocumentActivityQueryFilter filters = query.getFilters();
        if (filters != null && (types = filters.getTypes()) != null && !types.isEmpty()) {
            StringBuilder clause = new StringBuilder("( ");
            for (DocumentActivityActionTypesFilter type : types) {
                if (type.getSubtypes() != null && !type.getSubtypes().isEmpty()) {
                    String placeHolder = type.getSubtypes().stream().map(s -> "?").collect(Collectors.joining(","));
                    clause.append("(ACTION_TYPE = ? AND ACTION_SUBTYPE IN (").append(placeHolder).append(") )");
                    values.add(type.getType());
                    values.addAll(type.getSubtypes());
                } else {
                    clause.append("ACTION_TYPE = ?");
                    values.add(type.getType());
                }
                clause.append(" OR ");
            }
            clause = new StringBuilder(clause.substring(0, clause.length() - 3) + ")");
            return Query.select().where(clause.toString(), values.toArray());
        }
        return null;
    }

    @Override
    public boolean shouldApply(DocumentActivityQuery query) {
        DocumentActivityQueryFilter filters = query.getFilters();
        if (filters != null) {
            List<DocumentActivityActionTypesFilter> types = filters.getTypes();
            return types != null && !types.isEmpty();
        }
        return false;
    }
}

