/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.command;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.core.service.AbstractServiceCommand;
import com.atlassian.confluence.core.service.ServiceCommand;
import com.atlassian.confluence.core.service.ServiceCommandValidator;
import com.atlassian.confluence.core.service.ValidationError;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.actions.AbstractCommandAction;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoc.AdhocWorkflowManager;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.WorkflowUserException;
import com.comalatech.confluence.workflowcontainer.WorkflowContainerManager;
import com.opensymphony.util.TextUtils;
import java.util.Arrays;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAdhocWorkflowCommand
extends AbstractCommandAction {
    private static final Logger log = LoggerFactory.getLogger(AbstractAdhocWorkflowCommand.class);
    private long pageId;
    protected String workflowName;
    private String key;
    private AbstractPage page;
    private Workflow workflow;
    private boolean production;
    private PageManager pageManager;
    private SpaceManager spaceManager;
    protected WorkflowContainerManager workflowContainerManager;
    protected AdhocWorkflowManager adhocWorkflowManager;
    protected AccessModeService accessModeService;
    private WorkflowResponse response;
    protected String stateName;
    protected String taskName;
    private Space space;

    public AbstractPage getPage() {
        if (this.page == null) {
            this.page = this.pageManager.getAbstractPage(this.pageId);
        }
        return this.page;
    }

    public Space getSpace() {
        if (this.space == null) {
            this.space = this.spaceManager.getSpace(this.key);
        }
        return this.space;
    }

    public String getSpaceKey() {
        if (this.getSpace() != null) {
            return this.getSpace().getKey();
        }
        return null;
    }

    private Workflow getWorkflow() {
        try {
            if (this.workflow != null) {
                return this.workflow;
            }
            this.workflow = this.getPage() != null ? this.adhocWorkflowManager.getPageWorkflow(this.getPage()) : (this.production ? this.workflowContainerManager.getProductionWorkflow(this.getSpaceKey(), this.workflowName) : this.workflowContainerManager.getWorkflowTemplate(this.getSpaceKey(), this.workflowName));
        }
        catch (WorkflowException e) {
            log.error(e.getMessage());
        }
        return this.workflow;
    }

    public abstract void doWithWorkflow(Workflow var1) throws WorkflowException;

    public abstract void validateWorkflow(ServiceCommandValidator var1, Workflow var2);

    public abstract boolean requiresExistingState();

    public abstract boolean requiresExistingTask();

    protected ServiceCommand createCommand() {
        return new AhdocWorkflowServiceCommand();
    }

    public void setPageId(long pageId) {
        this.pageId = pageId;
    }

    public long getPageId() {
        return this.pageId;
    }

    public Object getBean() {
        if (this.response == null) {
            this.response = new WorkflowResponse(false, "Internal Workflow error");
        }
        if (log.isDebugEnabled()) {
            log.debug("DEBUG: " + this.response);
        }
        return this.response;
    }

    public void setStateName(String stateName) {
        this.stateName = this.unscapeQuotes(stateName);
    }

    public void setTaskName(String taskName) {
        this.taskName = this.unscapeQuotes(taskName);
    }

    protected String unscapeQuotes(String str) {
        return str.replaceAll("\\\\'", "'").replaceAll("\\\\\"", "\"");
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    public boolean isProduction() {
        return this.production;
    }

    public void setProduction(boolean production) {
        this.production = production;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setWorkflowContainerManager(WorkflowContainerManager workflowContainerManager) {
        this.workflowContainerManager = workflowContainerManager;
    }

    public void setAdhocWorkflowManager(AdhocWorkflowManager adhocWorkflowManager) {
        this.adhocWorkflowManager = adhocWorkflowManager;
    }

    public void setAccessModeService(AccessModeService accessModeService) {
        this.accessModeService = accessModeService;
    }

    public class WorkflowResponse {
        private boolean ok;
        private String message;

        public WorkflowResponse() {
            this.ok = true;
            this.message = "";
        }

        public WorkflowResponse(boolean ok, String message) {
            this.ok = ok;
            this.message = message.replaceAll("\n", "\\\\n");
        }

        public boolean isOk() {
            return this.ok;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return "WorkflowResponse{ok=" + this.ok + ", message='" + this.message + '\'' + '}';
        }
    }

    public class AhdocWorkflowServiceCommand
    extends AbstractServiceCommand {
        protected void validateInternal(ServiceCommandValidator validator) {
            if (AbstractAdhocWorkflowCommand.this.getWorkflow() == null) {
                validator.addValidationError("there is no workflow on this page", new Object[0]);
            } else if (AbstractAdhocWorkflowCommand.this.requiresExistingState()) {
                State state = AbstractAdhocWorkflowCommand.this.workflow.getStatesContainer().getState(AbstractAdhocWorkflowCommand.this.stateName);
                if (state == null) {
                    validator.addValidationError("comalatech.awp.designer.error.state.name.invalid", new Object[]{AbstractAdhocWorkflowCommand.this.stateName});
                } else if (AbstractAdhocWorkflowCommand.this.requiresExistingTask() && state.getTask(AbstractAdhocWorkflowCommand.this.taskName) == null) {
                    validator.addValidationError("comalatech.awp.designer.error.task.name.invalid", new Object[]{AbstractAdhocWorkflowCommand.this.taskName});
                }
            }
            if (validator.getValidationErrors().size() == 0) {
                AbstractAdhocWorkflowCommand.this.validateWorkflow(validator, AbstractAdhocWorkflowCommand.this.getWorkflow());
            }
            if (validator.getValidationErrors().size() > 0) {
                ValidationError error = (ValidationError)validator.getValidationErrors().toArray()[0];
                AbstractAdhocWorkflowCommand.this.response = new WorkflowResponse(false, AbstractAdhocWorkflowCommand.this.getText(error.getMessageKey(), error.getArgs()));
            }
        }

        protected boolean isAuthorizedInternal() {
            if (AbstractAdhocWorkflowCommand.this.permissionManager.hasPermission((User)AbstractAdhocWorkflowCommand.this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION)) {
                return true;
            }
            if (AbstractAdhocWorkflowCommand.this.getPage() != null) {
                return this.hasEditPermissionOnPage();
            }
            return TextUtils.stringSet((String)AbstractAdhocWorkflowCommand.this.key) && AbstractAdhocWorkflowCommand.this.permissionManager.hasPermission((User)AbstractAdhocWorkflowCommand.this.getAuthenticatedUser(), Permission.ADMINISTER, (Object)AbstractAdhocWorkflowCommand.this.getSpace());
        }

        private boolean hasEditPermissionOnPage() {
            return (Boolean)AbstractAdhocWorkflowCommand.this.accessModeService.withReadOnlyAccessExemption(() -> AbstractAdhocWorkflowCommand.this.permissionManager.hasPermission((User)AbstractAdhocWorkflowCommand.this.getAuthenticatedUser(), Permission.EDIT, (Object)AbstractAdhocWorkflowCommand.this.getPage()));
        }

        protected void executeInternal() {
            try {
                if (log.isDebugEnabled()) {
                    this.logParams();
                }
                AbstractAdhocWorkflowCommand.this.doWithWorkflow(AbstractAdhocWorkflowCommand.this.getWorkflow());
                AbstractAdhocWorkflowCommand.this.response = new WorkflowResponse();
                if (log.isDebugEnabled()) {
                    log.debug("current workflow:\n" + AbstractAdhocWorkflowCommand.this.getWorkflow().toMacro().toString());
                }
            }
            catch (WorkflowUserException e) {
                AbstractAdhocWorkflowCommand.this.response = new WorkflowResponse(false, e.getMessage());
            }
            catch (WorkflowException e) {
                AbstractAdhocWorkflowCommand.this.response = new WorkflowResponse(false, e.getMessage());
                log.error("", (Throwable)e);
            }
            catch (Exception e) {
                AbstractAdhocWorkflowCommand.this.response = new WorkflowResponse(false, "Internal error, see server logs");
                log.error("", (Throwable)e);
            }
        }

        private void logParams() {
            StringBuilder sb = new StringBuilder("Params: ");
            Enumeration names = AbstractAdhocWorkflowCommand.this.getCurrentRequest().getParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String[] values = AbstractAdhocWorkflowCommand.this.getCurrentRequest().getParameterValues(name);
                sb.append(name).append("=").append(values.length > 1 ? Arrays.asList(values) : values[0]).append(" ");
            }
            log.debug(sb.toString());
        }
    }
}

