/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.migration.app.check;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class CheckSpec {
    private final String checkId;
    private final String title;
    private final String description;
    private final Map<String, String> stepsToResolve = new HashMap<String, String>();
    private static final int TITLE_CHARACTER_LIMIT = 60;
    private static final int STEPS_TO_RESOLVE_TEMPLATE_CHARACTER_LIMIT = 1050;
    private static final String TITLE_IS_INVALID_MSG = "Title cannot exceed 60 characters. Value will be truncated";
    private static final String STEPS_TEMPLATE_IS_INVALID_MSG = "exceeds 1050 characters. Template will be truncated.";

    public CheckSpec(String checkId, String title, String description, Map<String, String> potentialStepsToResolve) {
        if (this.isBlank(checkId)) {
            throw new IllegalArgumentException("'checkId' cannot be null or empty");
        }
        if (this.isBlank(title)) {
            throw new IllegalArgumentException("'title' cannot be null or empty");
        }
        if (Objects.isNull(potentialStepsToResolve) || potentialStepsToResolve.isEmpty()) {
            throw new IllegalArgumentException("'stepsToResolve' cannot be null or empty");
        }
        this.checkId = checkId;
        this.title = title;
        this.description = description;
        this.stepsToResolve.putAll(potentialStepsToResolve);
    }

    public CheckSpec(String checkId, String title, Map<String, String> potentialStepsToResolve) {
        this(checkId, title, null, potentialStepsToResolve);
    }

    public String getCheckId() {
        return this.checkId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, String> getStepsToResolve() {
        return this.stepsToResolve;
    }

    public List<String> validate() {
        ArrayList<String> errorList = new ArrayList<String>();
        if (!this.isTitleValid()) {
            errorList.add(TITLE_IS_INVALID_MSG);
        }
        for (String templateId : this.getInvalidTemplates()) {
            errorList.add("Template with id '" + templateId + "' " + STEPS_TEMPLATE_IS_INVALID_MSG);
        }
        return errorList;
    }

    private boolean isTitleValid() {
        return this.title.length() <= 60;
    }

    private List<String> getInvalidTemplates() {
        return this.stepsToResolve.entrySet().stream().filter(entrySet -> ((String)entrySet.getValue()).length() > 1050).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private boolean isBlank(CharSequence value) {
        int strLen;
        int n = strLen = value == null ? 0 : value.length();
        if (strLen == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckSpec that = (CheckSpec)o;
        return this.checkId.equals(that.checkId);
    }

    public int hashCode() {
        return Objects.hash(this.checkId);
    }
}

