/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.storage.servlet;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.randombits.storage.BasedStorage;
import org.randombits.storage.StringBasedStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestHeaderStorage
extends StringBasedStorage {
    private HttpServletRequest req;
    private Set<String> headerNames;

    public RequestHeaderStorage(HttpServletRequest req) {
        super(BasedStorage.BoxType.Virtual);
        this.req = req;
    }

    @Override
    protected Set<String> baseNameSet() {
        if (this.headerNames == null) {
            this.headerNames = new HashSet<String>();
            Enumeration names = this.req.getHeaderNames();
            while (names.hasMoreElements()) {
                this.headerNames.add((String)names.nextElement());
            }
        }
        return this.headerNames;
    }

    @Override
    protected String getBaseString(String name) {
        return this.req.getHeader(name);
    }

    @Override
    protected void setBaseString(String name, String value) {
        this.checkReadOnly();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }
}

