/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.search;

import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.query.TermQuery;
import com.comalatech.confluence.workflow.Constants;
import java.util.Collections;
import java.util.List;

public class ApproverQuery
implements SearchQuery {
    private String approvalName;
    private final String userName;

    public ApproverQuery(String userName) {
        this.userName = userName;
    }

    public ApproverQuery(String approvalName, String userName) {
        this.approvalName = approvalName;
        this.userName = userName;
    }

    public String getKey() {
        return "approvalapprover";
    }

    public String getFieldName() {
        if (this.approvalName != null) {
            return Constants.makeApprovalSelectionId(this.approvalName);
        }
        return "approver";
    }

    public List getParameters() {
        return Collections.singletonList(this.approvalName);
    }

    public String getApprovalName() {
        return this.approvalName;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApproverQuery that = (ApproverQuery)o;
        if (this.approvalName != null ? !this.approvalName.equals(that.approvalName) : that.approvalName != null) {
            return false;
        }
        return this.userName != null ? this.userName.equals(that.userName) : that.userName == null;
    }

    public int hashCode() {
        int result = this.approvalName != null ? this.approvalName.hashCode() : 0;
        result = 31 * result + (this.userName != null ? this.userName.hashCode() : 0);
        return result;
    }

    public SearchQuery expand() {
        return new TermQuery(this.getFieldName(), this.userName);
    }
}

