/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.macro.parameter.mappers;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.comalatech.confluence.workflowreports.macro.parameter.ReportParameter;
import com.comalatech.confluence.workflowreports.macro.parameter.StateReportParameters;
import com.comalatech.confluence.workflowreports.macro.parameter.StringReportParameterValue;
import com.comalatech.confluence.workflowreports.macro.parameter.mappers.ParameterMapper;
import com.opensymphony.util.TextUtils;

public class UsernameParameterMapper
implements ParameterMapper {
    private final UserAccessor userAccessor;
    private static final String SELF = "@self";

    public UsernameParameterMapper(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Override
    public ReportParameter map(ReportParameter parameter) {
        if (this.parameterCanBeMapped(parameter)) {
            StringReportParameterValue value = (StringReportParameterValue)parameter.getValue();
            String username = value.getValueOrDefault();
            ConfluenceUser user = null;
            if (SELF.equals(username)) {
                user = AuthenticatedUserThreadLocal.get();
            } else if (TextUtils.stringSet((String)username)) {
                user = this.userAccessor.getUserByName(username);
            }
            String userKey = user != null ? user.getKey().getStringValue() : null;
            parameter.setValue(new StringReportParameterValue(userKey, (String)value.getDefaultValue()));
        }
        return parameter;
    }

    @Override
    public boolean parameterCanBeMapped(ReportParameter parameter) {
        return parameter.keyIs(StateReportParameters.APPROVAL_ASSIGNED_TO.getKey()) && parameter.getValue() instanceof StringReportParameterValue;
    }
}

