/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.action;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.spaces.actions.SpaceAware;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoc.dao.SpaceUIConfigDao;
import com.comalatech.confluence.dataextractor.DataExtractorManager;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.readack.model.ReadAckStatusType;
import com.comalatech.confluence.readack.reports.model.ReadAckSpaceReportSettings;
import com.comalatech.confluence.readack.service.ReadAckSearchService;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.WorkflowService;
import com.comalatech.confluence.workflow.restv2.model.report.RestSpaceReportFilterWorkflow;
import com.comalatech.confluence.workflow.service.ApprovalsSearchService;
import com.comalatech.confluence.workflowcontainer.model.WorkflowVisibilityInternal;
import com.comalatech.workflow.model.Workflow;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewWorkflowReportAction
extends AbstractSpaceAction
implements SpaceAware {
    private static final Logger log = LoggerFactory.getLogger(NewWorkflowReportAction.class);
    public static final String REPORT_SETTINGS_KEY = "reportColumnSettings";
    public static final String REPORT_FILTER_STATES_KEY = "filterStates";
    public static final String REPORT_FILTER_WORKFLOWS_KEY = "filterWorkflows";
    public static final String READACK_REPORT_SETTINGS_KEY = "readAckReportColumnSettings";
    public static final String READACK_REPORT_FILTER_STATUS_KEY = "readAckFilterStatus";
    public static final String READACK_REPORT_SHOW_READACK_TAB_KEY = "showReadAckReport";
    private AccessModeService accessModeService;
    private WorkflowConfigurationManager workflowConfigurationManager;
    private SpaceUIConfigDao spaceUIConfigDao;
    private ApprovalsSearchService approvalsSearchService;
    private WorkflowService workflowService;
    private WorkflowsFeatureManager workflowsFeatureManager;
    private DataExtractorManager dataExtractorManager;
    private ReadAckSearchService readAckSearchService;
    private DarkFeatureManager darkFeatureManager;

    public String execute() {
        return "success";
    }

    private String buildReportColumnSettingsJSON() {
        try {
            return new ObjectMapper().writeValueAsString(this.spaceUIConfigDao.getSpaceUIConfig(this.getSpaceKey()).getRestSettings());
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    private String buildReportStateFilterJSON() {
        return this.approvalsSearchService.getSpaceStates(this.getSpaceKey()).stream().map(state -> "\"" + state + "\"").collect(Collectors.toList()).toString();
    }

    private String buildReportWorkflowFilterJSON() {
        if (!this.workflowsFeatureManager.isWorkflowsApp()) {
            return "";
        }
        List<Workflow> workflows = this.workflowService.getWorkflows(this.getSpaceKey());
        ArrayList<RestSpaceReportFilterWorkflow> restWorkflows = new ArrayList<RestSpaceReportFilterWorkflow>();
        for (Workflow workflow : workflows) {
            if (!workflow.isActive()) continue;
            RestSpaceReportFilterWorkflow restWorkflow = new RestSpaceReportFilterWorkflow();
            restWorkflow.name = workflow.getName();
            restWorkflow.states = workflow.getStateNames();
            restWorkflows.add(restWorkflow);
        }
        try {
            return new ObjectMapper().writeValueAsString(restWorkflows);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    private String buildReadAckColumnSettingsJSON() {
        try {
            return new ObjectMapper().writeValueAsString(new ReadAckSpaceReportSettings().getRestSettings());
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    private String buildReadAckStatusFilterJSON() {
        return Arrays.stream(ReadAckStatusType.PageStatusType.values()).map(status -> "\"" + (Object)status + "\"").collect(Collectors.toList()).toString();
    }

    public String getReportStateFilter() {
        return this.buildReportStateFilterJSON();
    }

    public String getReportColumnSettings() {
        return this.buildReportColumnSettingsJSON();
    }

    public String getReportWorkflowFilter() {
        return this.buildReportWorkflowFilterJSON();
    }

    public String getReportColumnSettingsId() {
        return REPORT_SETTINGS_KEY;
    }

    public String getReportFilterStatesKey() {
        return REPORT_FILTER_STATES_KEY;
    }

    public String getReportFilterWorkflowsKey() {
        return REPORT_FILTER_WORKFLOWS_KEY;
    }

    public String getReadackReportSettingsKey() {
        return READACK_REPORT_SETTINGS_KEY;
    }

    public String getReadackReportFilterStatesKey() {
        return READACK_REPORT_FILTER_STATUS_KEY;
    }

    public String getReadackReportShowReadAckTabKey() {
        return READACK_REPORT_SHOW_READACK_TAB_KEY;
    }

    public String getReadackReportColumnSettings() {
        return this.buildReadAckColumnSettingsJSON();
    }

    public String getReadackStatusFilter() {
        return this.buildReadAckStatusFilterJSON();
    }

    public boolean showReadAckReport() {
        if (!this.darkFeatureManager.isFeatureEnabledForAllUsers("comalatech.workflows.readack.report.show")) {
            return false;
        }
        return this.readAckSearchService.spaceHasReadAck(this.space.getKey());
    }

    public boolean isPermitted() {
        boolean superIsPermitted = super.isPermitted();
        return (Boolean)this.accessModeService.withReadOnlyAccessExemption(() -> {
            WorkflowVisibilityInternal visibility = this.workflowConfigurationManager.getHistoryVisibility(this.getSpaceKey());
            if (WorkflowVisibilityInternal.CONTRIBUTORS.equals((Object)visibility)) {
                return superIsPermitted && this.spacePermissionManager.hasPermission("EDITSPACE", this.space, (User)AuthenticatedUserThreadLocal.get());
            }
            if (WorkflowVisibilityInternal.ANY.equals((Object)visibility)) {
                return superIsPermitted && this.spacePermissionManager.hasPermission("VIEWSPACE", this.space, (User)AuthenticatedUserThreadLocal.get());
            }
            return superIsPermitted;
        });
    }

    public boolean isSpaceAdmin() {
        return this.spacePermissionManager.hasPermission("SETSPACEPERMISSIONS", this.space, (User)this.getAuthenticatedUser()) || this.permissionManager.isConfluenceAdministrator((User)this.getAuthenticatedUser());
    }

    public boolean isPopulatorTaskRunning() {
        return this.dataExtractorManager.isPopulatorTaskRunning();
    }

    public boolean isSpaceRequired() {
        return true;
    }

    public boolean isViewPermissionRequired() {
        return true;
    }

    public void setWorkflowConfigurationManager(WorkflowConfigurationManager workflowConfigurationManager) {
        this.workflowConfigurationManager = workflowConfigurationManager;
    }

    public void setAccessModeService(AccessModeService accessModeService) {
        this.accessModeService = accessModeService;
    }

    public void setSpaceUIConfigDao(SpaceUIConfigDao spaceUIConfigDao) {
        this.spaceUIConfigDao = spaceUIConfigDao;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public void setApprovalsSearchService(ApprovalsSearchService approvalsSearchService) {
        this.approvalsSearchService = approvalsSearchService;
    }

    public void setDataExtractorManager(DataExtractorManager dataExtractorManager) {
        this.dataExtractorManager = dataExtractorManager;
    }

    public void setWorkflowsFeatureManager(WorkflowsFeatureManager workflowsFeatureManager) {
        this.workflowsFeatureManager = workflowsFeatureManager;
    }

    public void setReadAckSearchService(ReadAckSearchService readAckSearchService) {
        this.readAckSearchService = readAckSearchService;
    }

    public void setDarkFeatureManager(DarkFeatureManager darkFeatureManager) {
        this.darkFeatureManager = darkFeatureManager;
    }
}

