/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.supportconsole.mappers;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.TrustedRequest;
import com.atlassian.sal.api.net.TrustedRequestFactory;
import com.comalatech.confluence.workflow.supportconsole.mappers.contract.SupportConsoleReportDataPopulator;
import com.comalatech.confluence.workflow.supportconsole.model.PageStatusData;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class PageStatusDataPopulator
implements SupportConsoleReportDataPopulator<PageStatusData, AbstractPage> {
    private static final Logger log = LoggerFactory.getLogger(PageStatusDataPopulator.class);
    private final TrustedRequestFactory<?> requestFactory;
    private SettingsManager settingsManager;

    public PageStatusDataPopulator(@Qualifier(value="trustedRequestFactory") TrustedRequestFactory requestFactory, SettingsManager settingsManager) {
        this.requestFactory = requestFactory;
        this.settingsManager = settingsManager;
    }

    @Override
    public PageStatusData populateForTarget(AbstractPage page) {
        return PageStatusData.builder().publishedPageStatus(this.getContentWorkflowStatus(page.getIdAsString())).build();
    }

    private String getContentWorkflowStatus(String pageId) {
        String baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
        String expand = "state,states,approvals,actions,tasks";
        String urlPath = baseUrl + "/rest/cw/1/content/" + pageId + "/status?expand=" + expand;
        String response = "";
        try {
            TrustedRequest request = this.requestFactory.createTrustedRequest(Request.MethodType.GET, urlPath);
            request.addTrustedTokenAuthentication(this.getDomainName(baseUrl));
            response = request.execute();
        }
        catch (Exception e) {
            log.warn("Error doing Get request from {}", (Object)urlPath, (Object)e);
        }
        return response;
    }

    private String getDomainName(String baseUrl) throws URISyntaxException {
        URI uri = new URI(baseUrl);
        String domain = uri.getHost();
        return domain.startsWith("www.") ? domain.substring(4) : domain;
    }
}

