/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.esignatures.configuration;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.comalatech.confluence.adhoc.dao.ComalatechBandanaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESignaturesConfigurationManager {
    private static final Logger log = LoggerFactory.getLogger(ESignaturesConfigurationManager.class);
    private static final String CONFIG_ESIGNATURES_CREDENTIALS_KEY = "com.comalatech.workflow.esignatures.credentials";
    private static final String DEFAULT_ESIGNATURES_CREDENTIALS = "confluence";
    private final BandanaManager bandanaManager;
    private final BandanaContext bandanaContext = ComalatechBandanaContext.COMALATECH_CONTEXT;

    public ESignaturesConfigurationManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    public String getESignaturesCredentials() {
        String eSignaturesCredentials = (String)this.bandanaManager.getValue(this.bandanaContext, CONFIG_ESIGNATURES_CREDENTIALS_KEY);
        return eSignaturesCredentials != null ? eSignaturesCredentials : DEFAULT_ESIGNATURES_CREDENTIALS;
    }

    public void setESignaturesCredentials(String eSignaturesCredentials) {
        this.bandanaManager.setValue(this.bandanaContext, CONFIG_ESIGNATURES_CREDENTIALS_KEY, (Object)eSignaturesCredentials);
        if (log.isDebugEnabled()) {
            log.debug("E-Signatures Credentials configuration saved : " + eSignaturesCredentials);
        }
    }
}

