/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.documentReport;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.actions.ProfilePictureInfo;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import com.comalatech.confluence.dataextractor.model.UserContentPropertyModel;
import com.comalatech.confluence.dataextractor.model.UserContentPropertyModelBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum UsersContentPropertiesKeys {
    COMALA_WORKFLOWS_PENDING_APPROVERS("comalaworkflowspendingapprovers"),
    COMALA_WORKFLOWS_FINISHED_APPROVERS("comalaworkflowsfinishedapprovers"),
    COMALA_WORKFLOWS_LAST_FINAL_VERSION_APPROVERS("comalaworkflowslastfinalversionapprovers");

    private static final Logger log;
    private final String value;

    private UsersContentPropertiesKeys(String value) {
        this.value = value;
    }

    public static Optional<UsersContentPropertiesKeys> fromString(String text) {
        return Arrays.stream(UsersContentPropertiesKeys.values()).filter(userData -> userData.value.equalsIgnoreCase(text)).findFirst();
    }

    public List<UserContentPropertyModel> getUserData(String json, UserAccessor accessor) {
        ArrayList<UserContentPropertyModel> result = new ArrayList<UserContentPropertyModel>();
        LinkedHashMap approvers = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationConfig.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
            approvers = (LinkedHashMap)mapper.readValue(json, LinkedHashMap.class);
        }
        catch (Exception ex) {
            log.warn("Cannot extract approvers key list from JsonContent Property {} : {}", new Object[]{json, this, ex});
        }
        if (approvers != null) {
            List userKeyList = (List)approvers.get("userKeyList");
            return this.getUserData(userKeyList, accessor);
        }
        return result;
    }

    public List<UserContentPropertyModel> getUserData(List<String> userKeyList, UserAccessor accessor) {
        ArrayList<UserContentPropertyModel> result = new ArrayList<UserContentPropertyModel>();
        if (userKeyList != null) {
            for (String key : userKeyList) {
                UserContentPropertyModel userContentPropertyModel = this.getUserDataFromKey(key, accessor);
                if (userContentPropertyModel == null) continue;
                result.add(userContentPropertyModel);
            }
        }
        return result;
    }

    public UserContentPropertyModel getUserDataFromKey(String key, UserAccessor accessor) {
        ConfluenceUser userByKey = accessor.getUserByKey(new UserKey(key));
        if (userByKey != null) {
            ProfilePictureInfo userProfilePicture = accessor.getUserProfilePicture((User)userByKey);
            return new UserContentPropertyModelBuilder().withUserName(userByKey.getName()).withDisplayName(userByKey.getFullName()).withPath(userProfilePicture.getUriReference()).withUserKey(key).build();
        }
        log.warn("Could NOT resolve data for userKey {}", (Object)key);
        return null;
    }

    static {
        log = LoggerFactory.getLogger(UsersContentPropertiesKeys.class);
    }
}

