/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoc.AdhocWorkflowManager;
import com.comalatech.confluence.adhoc.action.DesignerTab;
import com.comalatech.confluence.adhoc.action.EditWorkflowHelper;
import com.comalatech.confluence.license.AdhocWorkflowsLicenseManager;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflowcontainer.WorkflowContainerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class EditGlobalWorkflowAction
extends ConfluenceActionSupport {
    private static final Logger log = LoggerFactory.getLogger(EditGlobalWorkflowAction.class);
    private AdhocWorkflowManager adhocWorkflowManager;
    private WorkflowContainerManager workflowContainerManager;
    private EditWorkflowHelper editWorkflowHelper;
    private AdhocWorkflowsLicenseManager licenseManager;
    private String workflowName;
    private String tab;

    public String execute() throws Exception {
        try {
            Workflow workflow = this.workflowContainerManager.getWorkflowTemplate(null, this.workflowName);
            if (workflow != null) {
                this.editWorkflowHelper = new EditWorkflowHelper(workflow, DesignerTab.parse(this.tab), null, false, false);
                return "success";
            }
            return "error";
        }
        catch (WorkflowException e) {
            log.error(e.getMessage());
            return "error";
        }
    }

    public EditWorkflowHelper getEditWorkflowHelper() {
        return this.editWorkflowHelper;
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    public void setAdhocWorkflowManager(AdhocWorkflowManager adhocWorkflowManager) {
        this.adhocWorkflowManager = adhocWorkflowManager;
    }

    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    public void setTab(String tab) {
        this.tab = tab;
    }

    public void setWorkflowContainerManager(WorkflowContainerManager workflowContainerManager) {
        this.workflowContainerManager = workflowContainerManager;
    }

    public AdhocWorkflowsLicenseManager getLicenseManager() {
        return this.licenseManager;
    }

    public void setLicenseManager(@Qualifier(value="adhocWorkflowsLicenseManager") AdhocWorkflowsLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }
}

