/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var requirejs = require || requirejs;
requirejs(['cw', 'jquery'], function(CW, $) {
    CW.toInit(function () {
        $('.cw-worfklow-states-report-container[data-cw-report]').each(function (i, item) {
            var $target = $(item);
            var pageId = $target.data('cwPageId') || CW.getParam('pageId');
            var spaceKey = $target.data('cwSpaceKey');
            var numberOfItemsPerPage = $target.data('cwNumberOfItems');
            var filterWorkflows = $target.data('cwWorkflowFilterOptions');
            var filterStates = $target.data('cwStateFilterOptions');
            var columnsToShow = $target.data('cwColumnsToShow');
            var cqlQuery = $target.data('cwCql');
            var showLiveFiltering = $target.data('cwShowLiveFiltering');
            var preSelectedStates = $target.data('cwPreSelectedStates');
            var preSelectedWorkflows = $target.data('cwPreSelectedWorkflows');

            // Workflow States Report Macro Iframe
            var WorkflowStatesReportIframe = new CW.iframe({
                id: 'WorkflowStatesReportIframe-' + pageId + '-' + i,
                url: '/report/states/'+ spaceKey,
                width: '100%',
                height: '100%',
                query: {
                    rowsPerPage: numberOfItemsPerPage,
                    columnsToShow: columnsToShow
                },
                customData: {
                    spaceKey: spaceKey,
                    filterNumberOfItems: numberOfItemsPerPage,
                    filterWorkflows: filterWorkflows,
                    filterStates: filterStates,
                    cqlQuery: cqlQuery,
                    showLiveFiltering: showLiveFiltering,
                    preSelectedStates: preSelectedStates,
                    preSelectedWorkflows: preSelectedWorkflows,
                }
            });
            $target.html(WorkflowStatesReportIframe.render());
        })
    });
});
