/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

function initWorkflowChart() {
    jQuery(".aprv-stateschart area").click(nopSelectState).hover(hoverInState,hoverOutState).attr("title","");
}
function nopSelectState() {
    return false;
}

function hoverInState(e) {
    var jthis = jQuery(this);
    var nodeId;
    if (jQuery.browser.msie && (jQuery.browser.version.indexOf("6.") == 0 || jQuery.browser.version.indexOf("7.") == 0)) {
        var href = jthis.attr("href");
        nodeId = href.substring(href.indexOf("#") + 1);
    } else {
        nodeId = jthis.attr("href");
    }
    var offset = jQuery("#aprv-chartbox").offset();
    var x = 0;
    var y = 0;
    var z = 0;
    if (offset) {
        z = offset.zIndex + 1;
        x = offset.left;
        y = offset.top + 10;
    }
    jQuery(nodeId).css("top", e.pageY - y).css("left", e.pageX - x).css("z-index", z).show();
}

function hoverOutState(e) {
    var jthis = jQuery(this);
    var nodeId;
    if (jQuery.browser.msie && (jQuery.browser.version.indexOf("6.") == 0 || jQuery.browser.version.indexOf("7.") == 0)) {
        var href = jthis.attr("href");
        nodeId = href.substring(href.indexOf("#") + 1);
    } else {
        nodeId = jthis.attr("href");
    }
    jQuery(nodeId).hide();

}

function hoverInChart(e) {
    var chart = jQuery("#aprv-chartbox");
    chart.removeClass("aprv-closing");
    if (! chart.hasClass("aprv-display")) {
        chart.addClass("aprv-display").css("left",e.pageX - chart.parent().offset().left).show();
        if (! chart.hasClass("aprv-loading")) {
            chart.addClass("aprv-loading");
            setTimeout("loadChart()",50);
        }
    }
}

function hoverOutChart(e) {
    jQuery("#aprv-chartbox").addClass("aprv-closing");
    setTimeout("hideChart()",300);
}

function hideChart() {
    if (jQuery("#aprv-chartbox").hasClass("aprv-closing")) {
        jQuery("#aprv-chartbox").removeClass("aprv-display").removeClass("aprv-closing").hide();
    }
}
//@deprecated
function reloadChart() {
    var chart = jQuery("#aprv-chartbox");
    if (chart.hasClass("aprv-loaded")) {
        chart.removeClass("aprv-loaded");
        loadChart();
    }
    return false;
}

function loadChart() {
    var pageId = getPageId();
    var mode = jQuery(".aprv-stateschart").attr("mode");
    var uri = getActionPath() + "chart.action?pageId=" + pageId;
    if (mode && mode.length > 0) {
        uri += "&chartMode=" + mode;
    }
    var chart = jQuery("#aprv-chartbox");
    chart.load(uri,function() {
        chart.addClass("aprv-loaded");
    });
}
