/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var Adhoc = Adhoc || {};

Adhoc.Approvals  = Adhoc.Approvals || {};

(function ($) {

    Adhoc.Approvals.hideApproval = function() {
        $(this).parents(".approvals .approval").removeClass("active");
        $("#workflow-main .button-panel.dialog").show();
        return false;
    };

    Adhoc.Approvals.showApproval = function() {
        $(this).parents(".approvals").find(".cancel-approval").click();
        var approval = $(this).parents(".approval");
        var action = $(this).attr("name");
        var form = approval.find("form");
        $(this).parents(".approvals .approval").removeClass("active");
        approval.addClass("active");
        approval.removeClass("approve").removeClass("reject").removeClass("assign");
        form.removeClass("approve").removeClass("reject").removeClass("assign");
        $("ol.assignees.select").empty();
        approval.addClass(action);
        form.addClass(action);
        var $button = approval.find(".button-panel input[name='" + action + "']");

        $button.toggleClass("highlight");
        setTimeout(function() {
            $button.toggleClass("highlight");
        },400);
        $("#workflow-main .button-panel.dialog").hide();
        return false;
    };

    Adhoc.Approvals.assign = function() {
        var approval = $(this).parents(".approval");
        var form = approval.find("form");
        form.removeClass("approve").removeClass("reject");
        form.addClass("assign");
        form.find("input.autocomplete-filtered-user").click().focus();
        return false;
    };

    Adhoc.Approvals.doAction = function() {
        var action = $(this).attr("name");
        var $form = $(this).parents("form");
        var approvalRequest = {
            assignee: Adhoc.getAssignees($form),
            user: $form.find("input[name='username']").val(),
            password: $form.find("input[name='password']").val(),
            name: $form.find("input[name='name']").val(),
            note: $form.find("textarea").val()
        };
        Adhoc.submitProgress($(this).parents(".adhoc"));
        $.ajax({
            type: "POST",
            cache: false,
            contentType: "application/json; charset=utf-8",
            url: AJS.Confluence.getContextPath() + "/rest/adhocworkflows/latest/approval/" + AJS.params.pageId + "/" + action,
            data: JSON.stringify(approvalRequest),
            success: function (pageStatus, textStatus, jqXHR) {
                if (jqXHR.status == 200) {
                    var stateChanged = Adhoc.state.stateName != pageStatus.stateName;
                    Adhoc.Workflow.setState(pageStatus);
                    if (! stateChanged) {
                        $("#adhocWorkflowsLink").click();
                    } else {
                        Adhoc.dialog.hide();
                    }
                } else {
                    Adhoc.dialog.hide();
                }
            },
            error: Adhoc.errorHandler
        });
        return false;
    };

    Adhoc.Approvals.doDialog = function(action, $contents) {

        var title;
        if (action.approvals.length > 1) {
            title = AJS.params.approvalsLabel;
        } else {
            title = "";
        }

        fillApprovalActions = function ($approval, approval) {
            var $menu = $approval.find(".approval-header .workflow-actions");

            for (var k = approval.actions.length - 1; k >= 0; k--) {
                $menu.append(AJS.template.load("adhoc-action").fill(approval.actions[k]));
            }
        };

        fillDefaultAction = function($approval, approval, captionApproval) {
            $name = $approval.find(".name");
            if (approval.hint != undefined) {
                $approval.attr("title",approval.hint);
            }
            if (approval.defaultAction != undefined) {
                approval.defaultAction.name = captionApproval.fullName ? captionApproval.fullName : captionApproval.name;
                approval.defaultAction.shortName = captionApproval.shortName;
                $name.append(AJS.template.load("adhocworkflows-approval-action-default").fill(approval));
            } else {
                $name.append(captionApproval.fullName ? captionApproval.fullName : captionApproval.name);
            }
        };

        var approvals = action.approvals;
        $contents.append(AJS.template.load("adhocworkflows-approvals").fill());
        var approvalSeparator = "";
        for (var i = 0; i < approvals.length; i++) {
            var approval = approvals[i];
            approval.separator = approvalSeparator;
            $contents.find(".approvals").append(AJS.template.load("adhocworkflows-approval").fill(approval));
            var $approval = $("#" + approval.id);
            if (approval.assignees != undefined && approval.assignees.length > 0) {
                Adhoc.setPresetUsers($approval.find(".usersdropdown .aui-dropdown ol"),approval.assignees);
                $approval.addClass("assignees");
            } else {
                Adhoc.setPresetUsers($approval.find(".usersdropdown .aui-dropdown ol"),action.involvedUsers);
            }
            if(approval.dueDate){
                $approval.find(".approval-duedate").html(AJS.template.load("adhocworkflows-approval-duedate").fill(approval));
            }
            if (approval.message != undefined && approval.message.length > 0) {
                $approval.find(".adhoc-message").html(approval.message);
            }
            fillApprovalActions($approval,approval);
            fillDefaultAction($approval,approval,approval);
            for (var j = 0; j < approval.approvers.length; j++) {
                var approver = approval.approvers[j];
                $contents.find(".approvals").append(AJS.template.load("adhocworkflows-approver").fill(approver));
                var $approver = $("#" + approver.id);
                fillApprovalActions($approver,approver);
                fillDefaultAction($approver,approver,approver.user);
            }
            approvalSeparator = "separator";
        }
        $contents.find(".workflow-action").click(Adhoc.Approvals.showApproval);
        $contents.find("form.approval input[type='submit']").click(Adhoc.Approvals.doAction);
        $contents.find(".cancel-approval").click(Adhoc.Approvals.hideApproval);
        $contents.find(".assign-approval").click(Adhoc.Approvals.assign);
        $contents.find(".cancel-dialog").click(Adhoc.doHidePopup);
        $contents.find(".usersdropdown").dropDown("Standard");
        if (! AJS.$.browser.msie) {
            $contents.find("input.autocomplete-filtered-user,input.assignee-user").click(function() {
                var $form = $(this).parents("form");
                $form.find(".usersdropdown a.aui-dd-trigger").click();
            });
        } else {
            // enable dropdown on IE only for when there are assignees
            $contents.find("div.approval.assignees input.assignee-user").click(function() {
                var $form = $(this).parents("form");
                $form.find(".usersdropdown a.aui-dd-trigger").click();
            });
        }
        $contents.find("input.autocomplete-filtered-user").bind("selected.autocomplete-filtered-user",Adhoc.selectAssignee);
        $contents.find("input.assignee-user").keypress(function(event) {
            event.preventDefault();
        });
        AWP.autocompleteFilteredUser();
        if (Adhoc.clickedApprovalId) {
            $("#" + Adhoc.clickedApprovalId + " .approval-header .name a").click();
            Adhoc.clickedApprovalId = undefined;
        } else if (! $("#adhocWorkflowsLink").hasClass("approvalworkflow")) {
            if ($contents.find(".approval-header").length == 1 &&  $contents.find("a.approve:first").length == 1) {
                $contents.find("a.approve:first").click();
            }
        }
    };

})(AJS.$);
