/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.storage.servlet;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.randombits.storage.BasedStorage;
import org.randombits.storage.ObjectBasedStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionStorage
extends ObjectBasedStorage {
    HttpSession session;

    public SessionStorage(HttpSession session) {
        super(BasedStorage.BoxType.Real);
        this.session = session;
    }

    @Override
    protected Set<String> baseNameSet() {
        Enumeration e = this.session.getAttributeNames();
        HashSet<String> names = new HashSet<String>();
        while (e.hasMoreElements()) {
            names.add((String)e.nextElement());
        }
        return names;
    }

    @Override
    protected Object getBaseObject(String name) {
        return this.session.getAttribute(name);
    }

    public HttpSession getSession() {
        return this.session;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    protected void setBaseObject(String name, Object value) {
        this.session.setAttribute(name, value);
    }
}

