/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.intercom;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.spring.container.ContainerManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.randombits.confluence.intercom.Connection;
import org.randombits.confluence.intercom.ConnectionBundle;
import org.randombits.confluence.intercom.Intercom4;
import org.randombits.confluence.intercom.LocalIntercomListener;
import org.randombits.facade.FacadeAssistant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalIntercom4
implements Intercom4 {
    private static final Logger LOG = Logger.getLogger(LocalIntercom4.class);
    private static final LocalIntercom4 INSTANCE = new LocalIntercom4();
    private Set<ConnectionBundle> mLocalBundles = new HashSet<ConnectionBundle>(5);
    private Set<ConnectionBundle> mRemoteBundles = new HashSet<ConnectionBundle>(10);
    private Set<Intercom4> _remoteIntercoms;
    private Plugin _plugin;
    private Set<LocalIntercomListener> listeners;
    private PluginAccessor pluginAccessor = (PluginAccessor)ContainerManager.getComponent((String)"pluginAccessor");
    private FacadeAssistant facadeAssistant = FacadeAssistant.getInstance();

    public static LocalIntercom4 getInstance() {
        return INSTANCE;
    }

    LocalIntercom4() {
    }

    public synchronized boolean addLocalBundle(ConnectionBundle bundle) {
        if (FacadeAssistant.getInstance().isLocalFacade(bundle)) {
            throw new IllegalArgumentException("Remote connection bundles cannot be added to local intercoms.");
        }
        if (this.mLocalBundles == null) {
            this.mLocalBundles = new HashSet<ConnectionBundle>(5);
        }
        if (this.mLocalBundles.add(bundle)) {
            this.notifyAddedConnectionBundle(bundle);
            for (Intercom4 intercom : this.getRemoteIntercoms()) {
                try {
                    intercom.addRemoteBundle(bundle);
                }
                catch (RuntimeException e) {
                    LOG.error((Object)("Unexpected exception: " + e.getLocalizedMessage()), (Throwable)e);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public ConnectionBundle[] getLocalBundles() {
        return this.mLocalBundles.toArray(new ConnectionBundle[this.mLocalBundles.size()]);
    }

    public synchronized boolean removeLocalBundle(ConnectionBundle bundle) {
        if (this.mLocalBundles.remove(bundle)) {
            this.notifyRemovedLocalBundle(bundle);
            return true;
        }
        return false;
    }

    private void notifyRemovedLocalBundle(ConnectionBundle bundle) {
        this.notifyRemovedConnectionBundle(bundle);
        for (Intercom4 intercom : this.getRemoteIntercoms()) {
            try {
                intercom.removeRemoteBundle(bundle);
            }
            catch (RuntimeException e) {
                LOG.error((Object)("Unexpected exception: " + e.getLocalizedMessage()), (Throwable)e);
            }
        }
    }

    public void clearLocalBundles() {
        Iterator<ConnectionBundle> i = this.mLocalBundles.iterator();
        while (i.hasNext()) {
            ConnectionBundle bundle = i.next();
            i.remove();
            this.notifyRemovedLocalBundle(bundle);
        }
    }

    @Override
    public synchronized boolean addRemoteBundle(ConnectionBundle bundle) {
        if (!FacadeAssistant.getInstance().isLocalFacade(bundle)) {
            throw new IllegalArgumentException("The collection bundle is not from a remote intercom.");
        }
        if (this.mRemoteBundles.add(bundle)) {
            this.notifyAddedConnectionBundle(bundle);
        }
        return false;
    }

    public ConnectionBundle[] getRemoteBundles() {
        return this.mRemoteBundles.toArray(new ConnectionBundle[this.mRemoteBundles.size()]);
    }

    @Override
    public synchronized boolean removeRemoteBundle(ConnectionBundle bundle) {
        if (this.mRemoteBundles.remove(bundle)) {
            this.notifyRemovedConnectionBundle(bundle);
        }
        return false;
    }

    private void notifyAddedConnectionBundle(ConnectionBundle bundle) {
        if (this.listeners != null) {
            for (LocalIntercomListener l : this.listeners) {
                try {
                    l.addedConnectionBundle(bundle);
                }
                catch (RuntimeException e) {
                    LOG.error((Object)("Unexpected RuntimeException while notifying intercom listeners: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    private void notifyRemovedConnectionBundle(ConnectionBundle bundle) {
        if (this.listeners != null) {
            for (LocalIntercomListener l : this.listeners) {
                l.removedConnectionBundle(bundle);
            }
        }
    }

    Set<Intercom4> getRemoteIntercoms() {
        if (this._remoteIntercoms == null) {
            this._remoteIntercoms = new HashSet<Intercom4>();
            Collection plugins = this.pluginAccessor.getPlugins();
            for (Plugin plugin : plugins) {
                Intercom4 intercom = this.findRemoteIntercom(plugin);
                if (intercom == null) continue;
                this.registerIntercom(intercom);
            }
        }
        return this._remoteIntercoms;
    }

    private Intercom4 findRemoteIntercom(Plugin plugin) {
        if (plugin.isDynamicallyLoaded()) {
            Class remoteIntercomClass;
            try {
                remoteIntercomClass = plugin.loadClass(LocalIntercom4.class.getName(), Object.class);
                if (LocalIntercom4.class == remoteIntercomClass) {
                    this._plugin = plugin;
                    return null;
                }
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            if (remoteIntercomClass != null) {
                try {
                    Method getInstance = remoteIntercomClass.getMethod("getInstance", new Class[0]);
                    Object remoteIntercom = getInstance.invoke(null, new Object[0]);
                    return this.facadeAssistant.prepareObject(remoteIntercom, Intercom4.class);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public synchronized void enable() {
        for (Intercom4 intercom : this.getRemoteIntercoms()) {
            intercom.registerIntercom(this);
        }
    }

    public synchronized void disable() {
        if (this._remoteIntercoms != null) {
            for (Intercom4 intercom : this._remoteIntercoms) {
                intercom.deregisterIntercom(this);
            }
            this._remoteIntercoms.clear();
            this._remoteIntercoms = null;
        }
        this.mRemoteBundles.clear();
    }

    private void addRemoteBundles(ConnectionBundle[] remoteBundles) {
        for (ConnectionBundle bundle : remoteBundles) {
            this.addRemoteBundle(bundle);
        }
    }

    private void removeRemoteBundles(ConnectionBundle[] connectionBundles) {
        for (ConnectionBundle bundle : connectionBundles) {
            this.removeRemoteBundle(bundle);
        }
    }

    @Override
    public synchronized boolean registerIntercom(Intercom4 intercom) {
        if (intercom == this) {
            return false;
        }
        if (this._remoteIntercoms == null) {
            this._remoteIntercoms = new HashSet<Intercom4>();
        }
        if (this._remoteIntercoms.add(intercom)) {
            try {
                this.addRemoteBundles(intercom.getLocalBundles());
                return true;
            }
            catch (RuntimeException e) {
                LOG.error((Object)("Unexpected exception while registering intercom '" + intercom + "' with '" + this + "'."), (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public synchronized boolean deregisterIntercom(Intercom4 intercom) {
        if (intercom == this) {
            return false;
        }
        assert (FacadeAssistant.getInstance().isFacade(intercom));
        if (this._remoteIntercoms != null && this._remoteIntercoms.remove(intercom)) {
            try {
                this.removeRemoteBundles(intercom.getLocalBundles());
                return true;
            }
            catch (RuntimeException e) {
                LOG.error((Object)("Unexpected exception while deregistering intercom '" + intercom + "' from '" + this + "'."), (Throwable)e);
            }
        }
        return false;
    }

    public Plugin getPlugin() {
        return this._plugin;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("LocalIntercom4");
        out.append(" [plugin: ");
        if (this._plugin != null) {
            out.append(this._plugin.getName()).append(" (").append(this._plugin.getKey()).append(")");
        } else {
            out.append("<unknown>");
        }
        out.append("]");
        return out.toString();
    }

    public void addLocalIntercomListener(LocalIntercomListener listener) {
        if (this.listeners == null) {
            this.listeners = new HashSet<LocalIntercomListener>();
        }
        this.listeners.add(listener);
    }

    public void removeLocalIntercomListener(LocalIntercomListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public synchronized <C extends Connection> Set<C> findConnections(Class<C> connectionType) {
        HashSet filtered = new HashSet(Math.max(this.mLocalBundles.size() + this.mRemoteBundles.size(), 10));
        this.addConnections(filtered, this.mLocalBundles, connectionType);
        this.addConnections(filtered, this.mRemoteBundles, connectionType);
        return filtered;
    }

    private <C extends Connection> void addConnections(Set<C> filtered, Set<ConnectionBundle> bundles, Class<C> connectionType) {
        for (ConnectionBundle bundle : bundles) {
            try {
                Connection[] connections = bundle.getConnections(connectionType);
                if (connections == null) continue;
                filtered.addAll(Arrays.asList(connections));
            }
            catch (NullPointerException e) {
                LOG.warn((Object)("A remote connection bundle is using a buggy version of Intercom: " + bundle), (Throwable)e);
            }
        }
    }
}

