/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.workflow.model;

import com.comalatech.workflow.model.WorkflowParameterType;
import com.webcohesion.enunciate.metadata.DocumentationExample;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonValue;

@XmlRootElement(name="input")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class InputField {
    @DocumentationExample(value="param1797958930", value2="param1876765907")
    private String id;
    @DocumentationExample(value="Reviewers", value2="Editor")
    private String name;
    @DocumentationExample(value="confluence-users", value2="admin")
    private String value;
    @DocumentationExample(value="group", value2="user")
    private InputType type;
    private List<String> options;
    @DocumentationExample(value="Reviewers group", value2="User that approves content")
    private String description;

    public InputField() {
    }

    public InputField(String id, String name, String value, InputType type) {
        this(id, name, null, value, type, null);
    }

    public InputField(String id, String name, String value, List<String> options) {
        this(id, name, null, value, InputType.LIST, options);
    }

    public InputField(String id, String name, String description, String value, InputType type, List<String> options) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.value = value;
        this.type = type;
        this.options = options;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getValue() {
        return this.value;
    }

    public InputType getType() {
        return this.type;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public static enum InputType {
        TEXT,
        USER,
        USERORGROUP,
        GROUP,
        DURATION,
        LIST;

        private static final Map<String, InputType> namesMap;

        @JsonCreator
        public static InputType forValue(String value) {
            return namesMap.get(StringUtils.lowerCase((String)value));
        }

        @JsonValue
        public String toValue() {
            for (Map.Entry<String, InputType> entry : namesMap.entrySet()) {
                if (entry.getValue() != this) continue;
                return entry.getKey();
            }
            return null;
        }

        public static InputType fromWorkflowParameterType(WorkflowParameterType type) {
            switch (type) {
                case STRING: {
                    return TEXT;
                }
                case USER: {
                    return USER;
                }
                case USERORGROUP: {
                    return USERORGROUP;
                }
                case GROUP: {
                    return GROUP;
                }
                case DURATION: {
                    return DURATION;
                }
                case LIST: {
                    return LIST;
                }
            }
            return TEXT;
        }

        static {
            namesMap = new HashMap<String, InputType>(3);
            namesMap.put("text", TEXT);
            namesMap.put("user", USER);
            namesMap.put("user-or-group", USERORGROUP);
            namesMap.put("group", GROUP);
            namesMap.put("duration", DURATION);
            namesMap.put("list", LIST);
        }
    }
}

