/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.rest.model;

import com.comalatech.confluence.workflow.rest.model.Condition;
import com.comalatech.confluence.workflowcontainer.model.SerializableMacro;
import com.comalatech.workflow.model.SignatureType;
import com.webcohesion.enunciate.metadata.DocumentationExample;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.codehaus.jackson.annotate.JsonSubTypes;
import org.codehaus.jackson.annotate.JsonTypeInfo;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Approval {
    @DocumentationExample(value="Approval 1", value2="Approval 2")
    public String name;
    @DocumentationExample(value="10", value2="1")
    public Integer weight;
    @DocumentationExample(value="label1", value2="label2")
    public String label;
    @DocumentationExample(value="password", value2="userid+password")
    public String credentials;
    public Approvers approvers;
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=Condition.PermissionCondition.class, name="permission"), @JsonSubTypes.Type(value=Condition.MetadataCondition.class, name="metadata"), @JsonSubTypes.Type(value=Condition.StateCondition.class, name="state"), @JsonSubTypes.Type(value=Condition.SpaceCondition.class, name="space"), @JsonSubTypes.Type(value=Condition.PageCondition.class, name="page"), @JsonSubTypes.Type(value=Condition.UserCondition.class, name="user"), @JsonSubTypes.Type(value=Condition.GroupCondition.class, name="group"), @JsonSubTypes.Type(value=Condition.AllowedAssignerUserCondition.class, name="allowedassignusers"), @JsonSubTypes.Type(value=Condition.AllowedAssignerGroupCondition.class, name="allowedassigngroups"), @JsonSubTypes.Type(value=Condition.ExcludeCondition.class, name="exclude"), @JsonSubTypes.Type(value=Condition.HasApprovalCondition.class, name="hasapproval"), @JsonSubTypes.Type(value=Condition.HasLabelCondition.class, name="haslabel")})
    public List<Condition> conditions;

    public Approval() {
    }

    public Approval(com.comalatech.confluence.workflow.model.Approval approval) {
        this.name = approval.getName();
        if (approval.getWeight() != 40) {
            this.weight = approval.getWeight();
        }
        if (approval.getLabel() != null) {
            this.label = approval.getLabel().getName();
        }
        if (approval.getCredentials() == SignatureType.PASSWORD) {
            this.credentials = "password";
        } else if (approval.getCredentials() == SignatureType.USERID_AND_PASSWORD) {
            this.credentials = "userid+password";
        }
        this.conditions = new ArrayList<Condition>();
        String assignedUsers = null;
        String assignedGroups = null;
        for (com.comalatech.confluence.workflow.model.Condition condition : approval.getConditions()) {
            SerializableMacro macro = new SerializableMacro("dummy");
            condition.addMacroParameters(macro);
            SerializableMacro.ParsedParameters params = macro.getParameters();
            if (params.has("user") && params.all) {
                assignedUsers = params.value;
                continue;
            }
            if (params.has("group") && params.all) {
                assignedGroups = params.value;
                continue;
            }
            Condition newCondition = Condition.build(params);
            if (newCondition == null) continue;
            this.conditions.add(newCondition);
        }
        this.approvers = this.makeApprovers(approval, assignedUsers, assignedGroups);
        if (this.conditions.size() == 0) {
            this.conditions = null;
        }
    }

    private Approvers makeApprovers(com.comalatech.confluence.workflow.model.Approval approval, String assignedUsers, String assignedGroups) {
        int minimumApprovers;
        try {
            minimumApprovers = Integer.parseInt(approval.getMinRequiredApprovers());
        }
        catch (NumberFormatException e) {
            minimumApprovers = 0;
        }
        String type = minimumApprovers > 1 ? "" + minimumApprovers + "+" : (assignedUsers != null || assignedGroups != null ? "all" : "*");
        return new Approvers(assignedUsers, assignedGroups, type);
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Approvers {
        @DocumentationExample(value="user1,user2,user3", value2="user6")
        public String users;
        @DocumentationExample(value="confluence-users,confluence-administrators", value2="confluence-users")
        public String groups;
        @DocumentationExample(value="*", value2="3+")
        public String minimum;

        public Approvers() {
        }

        public Approvers(String users, String groups, String minimum) {
            this.users = users;
            this.groups = groups;
            this.minimum = minimum;
        }
    }
}

