/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.macros;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.workflow.macros.AbstractAttachmentMacro;
import com.opensymphony.util.TextUtils;
import java.util.Map;

public class EmbedMacro
extends AbstractAttachmentMacro {
    public static final RenderMode RENDER_MODE = RenderMode.allow((long)1056L);
    public static final String ERROR_TAG = "<span class=\"error\"";
    private SubRenderer subRenderer;

    public String execute(Map parametersMap, String body, RenderContext renderContext) throws MacroException {
        try {
            AbstractPage page = (AbstractPage)((PageContext)renderContext).getEntity();
            AbstractAttachmentMacro.Parameters parameters = this.parseParameters(parametersMap);
            StringBuilder sb = new StringBuilder("!");
            sb.append(parameters.fileName);
            if (parameters.thumbnail) {
                sb.append("|").append("thumbnail");
            }
            if (TextUtils.stringSet((String)parameters.properties)) {
                sb.append("|").append(parameters.properties);
            }
            sb.append("!");
            String renderedImage = this.subRenderer.render(sb.toString(), renderContext, RENDER_MODE);
            if (renderedImage.contains(ERROR_TAG)) {
                return renderedImage;
            }
            this.loadAttachment(page, parameters);
            if (!parameters.attachment.isLatestVersion() && parameters.version > 0) {
                return renderedImage.replaceFirst(parameters.fileName, parameters.fileName + "?version=" + parameters.version);
            }
            return renderedImage;
        }
        catch (MacroException e) {
            return "<span class=\"error\">" + HtmlUtil.htmlEncode((String)e.getMessage()) + "</span>";
        }
    }

    public void setSubRenderer(SubRenderer subRenderer) {
        this.subRenderer = subRenderer;
    }
}

