/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.esignatures.actions;

import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.actions.AbstractUserProfileAction;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.comalatech.confluence.encryption.AESEncryptionException;
import com.comalatech.confluence.license.AdhocWorkflowsLicenseManager;
import com.comalatech.confluence.workflow.esignatures.configuration.ESignaturesConfigurationManager;
import com.comalatech.confluence.workflow.esignatures.model.ESignatureCredentials;
import com.comalatech.confluence.workflow.esignatures.model.SigningToken;
import com.comalatech.confluence.workflow.esignatures.service.ESignaturesService;
import com.comalatech.confluence.workflow.stats.WorkflowStatisticsManager;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class ESignaturesUserProfileAction
extends AbstractUserProfileAction {
    private static final Logger log = LoggerFactory.getLogger(ESignaturesUserProfileAction.class);
    protected static final String UUID = "uuid";
    private AdhocWorkflowsLicenseManager licenseManager;
    private WorkflowStatisticsManager workflowStatisticsManager;
    private ESignaturesConfigurationManager eSignaturesConfigurationManager;
    private ESignaturesService eSignaturesService;

    public String view() {
        return "success";
    }

    public String validateToken() {
        String uuid = this.getCurrentRequest().getParameter(UUID);
        ConfluenceUser loggedUser = AuthenticatedUserThreadLocal.get();
        try {
            String userKey = loggedUser.getKey().toString();
            SigningToken signingToken = this.eSignaturesService.getSigningToken(userKey);
            if (Objects.equals(signingToken.getUuid(), uuid)) {
                signingToken.setValidate(true);
                this.eSignaturesService.persistTemporarySigningToken(userKey, signingToken);
                return "success";
            }
        }
        catch (AESEncryptionException e) {
            log.warn("There has been a problem with decryption process", (Throwable)e);
            this.eSignaturesService.purgeTemporarySigningToken(loggedUser.getKey().toString());
        }
        catch (Exception e) {
            log.warn("Problem when validating email/UUID values!", (Throwable)e);
        }
        return "error";
    }

    public String render(String body) {
        PageContext context = new PageContext();
        context.pushRenderMode(RenderMode.suppress((long)1L));
        return this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)context, body);
    }

    public String getWorkflowLicenseMessageHtml() {
        return this.licenseManager.getLicenseStatus().getMessageHtml();
    }

    public boolean isPermitted() {
        return this.eSignaturesConfigurationManager.getESignaturesCredentials().equals(ESignatureCredentials.Credentials.OTP.getValue());
    }

    public void setLicenseManager(@Qualifier(value="adhocWorkflowsLicenseManager") AdhocWorkflowsLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public void setWorkflowStatisticsManager(WorkflowStatisticsManager workflowStatisticsManager) {
        this.workflowStatisticsManager = workflowStatisticsManager;
    }

    public void seteSignaturesConfigurationManager(ESignaturesConfigurationManager eSignaturesConfigurationManager) {
        this.eSignaturesConfigurationManager = eSignaturesConfigurationManager;
    }

    public WorkflowStatisticsManager getWorkflowStatisticsManager() {
        return this.workflowStatisticsManager;
    }

    public void seteSignaturesService(ESignaturesService eSignaturesService) {
        this.eSignaturesService = eSignaturesService;
    }

    protected HttpServletRequest getCurrentRequest() {
        return super.getCurrentRequest();
    }
}

