/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow;

import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.model.AllowedAssignerGroupCondition;
import com.comalatech.confluence.workflow.model.AllowedAssignerUserCondition;
import com.comalatech.confluence.workflow.model.ApproverCondition;
import com.comalatech.confluence.workflow.model.Condition;
import com.comalatech.confluence.workflow.model.ExcludeCondition;
import com.comalatech.confluence.workflow.model.GroupCondition;
import com.comalatech.confluence.workflow.model.Selector;
import com.comalatech.confluence.workflow.model.UserCondition;

public class ApproverConditionParser {
    public static final char EOF = '\uffff';
    public static final char INVALID = '\u0000';
    public static final char EQUALS = '=';
    public static final char COMMA = ',';
    public static final char PLUS = '+';
    public static final char AMPERSAND = '&';
    public static final char SPACE = ' ';
    public static final char ARROBA = '@';
    public static final char QUESTION = '?';
    public static final char NOT = '!';
    private static final String[] USER_PARAM = new String[]{"user", "users"};
    private static final String[] GROUP_PARAM = new String[]{"group", "groups", "usergroup", "usersgroup"};
    private static final String EXCLUDE_PARAM = "exclude";
    private static final String ALLOWEDASSIGNUSERS_PARAM = "allowedassignusers";
    private static final String ALLOWEDASSIGNGROUPS_PARAM = "allowedassigngroups";
    private static final String CONFLUENCE_MARKUP_START = "<at:var at:name=\"";
    private static final String CONFLUENCE_MARKUP_END = "\" />";
    private Tokenizer tokenizer;

    public static final Condition parse(String paramName, String paramValue) throws WorkflowException {
        ApproverConditionParser parser = new ApproverConditionParser(paramName, paramValue);
        return parser.parse();
    }

    private ApproverConditionParser(String paramName, String paramValue) {
        this.tokenizer = new Tokenizer(paramName + "=" + paramValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Condition parse() throws WorkflowException {
        String conditionType = this.id();
        boolean not = false;
        if (!this.equals(conditionType, USER_PARAM) && !this.equals(conditionType, GROUP_PARAM) && !conditionType.equals(EXCLUDE_PARAM) && !conditionType.equals(ALLOWEDASSIGNUSERS_PARAM) && !conditionType.equals(ALLOWEDASSIGNGROUPS_PARAM)) throw new WorkflowException("must define either 'user' or 'group' as condition");
        if (this.tokenizer.next() != '=') throw new WorkflowException("'=' expected");
        char token = this.tokenizer.nextIgnoreSpace();
        if (token == '!') {
            not = true;
        } else {
            this.tokenizer.push();
        }
        Selector selector = this.selector();
        token = this.tokenizer.nextIgnoreSpace();
        if (token == '\uffff') return this.createCondition(not, conditionType, selector);
        throw new WorkflowException("unexpected '" + token + "'");
    }

    private Condition createCondition(boolean not, String conditionType, Selector selector) {
        if (selector.isAnyCanApprove()) {
            if (this.equals(conditionType, GROUP_PARAM)) {
                return new GroupCondition(not, selector.getUsers());
            }
            if (conditionType.equals(EXCLUDE_PARAM)) {
                return new ExcludeCondition(selector.getUsers());
            }
            if (conditionType.equals(ALLOWEDASSIGNUSERS_PARAM)) {
                return new AllowedAssignerUserCondition(not, selector.getUsers());
            }
            if (conditionType.equals(ALLOWEDASSIGNGROUPS_PARAM)) {
                return new AllowedAssignerGroupCondition(not, selector.getUsers());
            }
            return new UserCondition(not, selector.getUsers());
        }
        return new ApproverCondition(selector, ApproverCondition.ApproverConditionType.fromString(conditionType));
    }

    private Selector selector() throws WorkflowException {
        Selector selector;
        char token = this.tokenizer.nextIgnoreSpace();
        if (token == '+' || token == '?' || token == '&') {
            selector = this.selectorPrime();
            if (token == '+') {
                selector.setType(2);
            } else if (token == '?') {
                selector.setType(1);
            } else {
                selector.setType(3);
            }
        } else {
            this.tokenizer.push();
            selector = this.selectorPrime();
        }
        return selector;
    }

    private Selector selectorPrime() throws WorkflowException {
        StringBuffer terms = new StringBuffer(this.term());
        char token = this.tokenizer.nextIgnoreSpace();
        int type = 0;
        while (token == '+' || token == '&' || token == ',' || token == '?') {
            type = this.getType(token);
            terms.append(',').append(this.term());
            token = this.tokenizer.nextIgnoreSpace();
        }
        this.tokenizer.push();
        return new Selector(terms.toString(), type);
    }

    private int getType(char token) {
        switch (token) {
            case '+': {
                return 2;
            }
            case '&': {
                return 3;
            }
        }
        return 0;
    }

    private String term() throws WorkflowException {
        char token = this.tokenizer.nextIgnoreSpace();
        this.tokenizer.push();
        String id = this.id();
        if (id.length() == 0) {
            throw new WorkflowException("caption, users names/groups or value reference expected");
        }
        return id;
    }

    private String id() throws WorkflowException {
        StringBuffer id = new StringBuffer();
        char token = this.tokenizer.nextIgnoreSpace();
        while (!(this.tokenizer.isSeparator(token) || token != ' ' && token == '\u0000')) {
            id.append(token);
            token = this.tokenizer.next();
        }
        this.tokenizer.push();
        return id.toString().trim();
    }

    private boolean equals(String str, String[] vals) {
        for (int i = 0; i < vals.length; ++i) {
            if (!str.equals(vals[i])) continue;
            return true;
        }
        return false;
    }

    private class Tokenizer {
        char[] chars;
        int ptr;
        boolean eof;

        private Tokenizer(String text) {
            this.chars = text.toCharArray();
            this.ptr = 0;
            this.eof = false;
        }

        public char next() {
            if (this.ptr >= this.chars.length) {
                this.eof = true;
                return '\uffff';
            }
            char daChar = this.chars[this.ptr++];
            switch (daChar) {
                case '|': {
                    return '\u0000';
                }
            }
            return daChar;
        }

        public char nextIgnoreSpace() {
            char token = this.next();
            while (token == ' ') {
                token = this.next();
            }
            return token;
        }

        public boolean isSeparator(char ch) {
            switch (ch) {
                case '!': 
                case '&': 
                case '+': 
                case ',': 
                case '=': 
                case '?': 
                case '\uffff': {
                    return true;
                }
            }
            return false;
        }

        public int arrobaCount(char[] text) {
            int count = 0;
            for (char c : text) {
                if ('@' != c) continue;
                ++count;
            }
            return count;
        }

        public void push() {
            if (this.ptr < this.chars.length || !this.eof) {
                --this.ptr;
            }
        }
    }
}

