/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.mapper.state;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.documentActivity.domain.entities.Action;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetail;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetails;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.domain.entities.Actor;
import com.comalatech.confluence.documentActivity.mapper.EventActivityMapper;
import com.comalatech.confluence.documentActivity.mapper.GenericEventActivityMapper;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.states.event.BlogPostStateTransitionOverrideEvent;
import com.comalatech.confluence.states.event.PageStateTransitionOverrideEvent;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.workflow.WorkflowUserException;

public class StateOverrideMapper
extends GenericEventActivityMapper
implements EventActivityMapper {
    public StateOverrideMapper(ActorUtils actorUtils) {
        super(actorUtils);
    }

    @Override
    public Activity map(ConfluenceEvent event) throws WorkflowUserException {
        if (event instanceof PageStateTransitionOverrideEvent) {
            PageStateTransitionOverrideEvent pageStateTransitionOverrideEvent = (PageStateTransitionOverrideEvent)event;
            return this.buildActivity((AbstractPage)pageStateTransitionOverrideEvent.getPage(), pageStateTransitionOverrideEvent.getState(), pageStateTransitionOverrideEvent.getPreviousEvent());
        }
        if (event instanceof BlogPostStateTransitionOverrideEvent) {
            BlogPostStateTransitionOverrideEvent blogPostStateTransitionOverrideEvent = (BlogPostStateTransitionOverrideEvent)event;
            return this.buildActivity((AbstractPage)blogPostStateTransitionOverrideEvent.getBlogPost(), blogPostStateTransitionOverrideEvent.getState(), blogPostStateTransitionOverrideEvent.getPreviousEvent());
        }
        return null;
    }

    protected Activity buildActivity(AbstractPage abstractPage, PageState targetState, PageState sourceState) throws WorkflowUserException {
        Actor actor = this.actorUtils.buildActor(targetState.getPerformer());
        ActionDetails details = new ActionDetails();
        details.addAll(this.buildStateActionDetails(targetState));
        if (targetState.getComment() != null && targetState.getComment().length() > 0) {
            details.addDetail(ActionDetail.Type.STATE_COMMENT, targetState.getComment());
        }
        if (sourceState != null) {
            details.addDetail(ActionDetail.Type.STATE_SOURCE, sourceState.getName());
        }
        Action action = new Action(new ActionType(ActionType.Type.STATE, ActionType.Subtype.STATE_OVERRIDE), actor, details);
        return new Activity(StateOverrideMapper.buildTarget((ContentEntityObject)abstractPage), targetState.getDate().getTime(), action);
    }
}

