/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.checklists.model;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.Page;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public class Row {
    private Page page;
    private String renderedPageLink;
    private final Map<Object, String> values = new HashMap<Object, String>();
    private final Map<Object, String> sortValues;
    private final Map<Object, String> renderedValues = new HashMap<Object, String>();
    private final Map<Object, String> cellIds;
    private boolean readOnly;
    private String pageSortValue;
    private long pageDateSortValue;
    private final String id;
    private final String genericId;

    public Row(Page page, String checklistId) {
        this.sortValues = new HashMap<Object, String>();
        this.cellIds = new HashMap<Object, String>();
        this.page = page;
        this.readOnly = false;
        this.id = checklistId + "_" + page.getIdAsString() + "_";
        this.genericId = page.getIdAsString();
    }

    public boolean isLabelSet(Label label) {
        return this.page.getLabels().contains(label);
    }

    public void setValues(Object columnKey, String cellId, String value, String sortValue, String renderedValue) {
        this.cellIds.put(columnKey, cellId);
        this.values.put(columnKey, value);
        this.sortValues.put(columnKey, sortValue);
        this.renderedValues.put(columnKey, renderedValue);
    }

    public String getCellId(Object columnKey) {
        return this.cellIds.get(columnKey);
    }

    public String getValue(Object columnKey) {
        return this.values.get(columnKey);
    }

    public String getSortValue(Object columnKey) {
        return this.sortValues.get(columnKey);
    }

    public String getRenderedValue(Object columnKey) {
        return this.renderedValues.get(columnKey);
    }

    @Generated
    public void setPage(Page page) {
        this.page = page;
    }

    @Generated
    public Page getPage() {
        return this.page;
    }

    @Generated
    public String getRenderedPageLink() {
        return this.renderedPageLink;
    }

    @Generated
    public void setRenderedPageLink(String renderedPageLink) {
        this.renderedPageLink = renderedPageLink;
    }

    @Generated
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Generated
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Generated
    public void setPageSortValue(String pageSortValue) {
        this.pageSortValue = pageSortValue;
    }

    @Generated
    public String getPageSortValue() {
        return this.pageSortValue;
    }

    @Generated
    public void setPageDateSortValue(long pageDateSortValue) {
        this.pageDateSortValue = pageDateSortValue;
    }

    @Generated
    public long getPageDateSortValue() {
        return this.pageDateSortValue;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getGenericId() {
        return this.genericId;
    }
}

