/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.checklists.model;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.pages.Page;
import com.comalatech.confluence.checklists.CellHandler;
import com.comalatech.confluence.checklists.ExcerptCellHandler;
import com.comalatech.confluence.checklists.IncludeCellHandler;
import com.comalatech.confluence.checklists.InputCellHandler;
import com.comalatech.confluence.checklists.LabelCellHandler;
import com.comalatech.confluence.checklists.PageRefCellHandler;
import com.comalatech.confluence.checklists.SelectCellHandler;
import com.comalatech.confluence.checklists.WikiCellHandler;
import com.comalatech.confluence.checklists.WikiInputCellHandler;
import com.comalatech.confluence.checklists.model.SelectOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Column {
    public static final int TYPE_NONE = 0;
    public static final int TYPE_LABEL = 1;
    public static final int TYPE_INPUT = 2;
    public static final int TYPE_EXCERPT = 3;
    public static final int TYPE_INCLUDE = 4;
    public static final int TYPE_WIKI = 5;
    public static final int TYPE_WIKIINPUT = 6;
    public static final int TYPE_SELECT = 7;
    public static final int TYPE_PAGEREF = 8;
    private static final String[] TYPES = new String[]{"", "label", "text", "excerpt", "include", "wiki", "wikiinput", "select", "pageref"};
    private static final CellHandler[] CELL_HANDLERS = new CellHandler[]{null, new LabelCellHandler(), new InputCellHandler(), new ExcerptCellHandler(), new IncludeCellHandler(), new WikiCellHandler(), new WikiInputCellHandler(), new SelectCellHandler(), new PageRefCellHandler()};
    private static LabelManager labelManager;
    private String heading;
    private int type;
    private String typeName;
    private Label label;
    private int cols;
    private int rows;
    private String id;
    private final String width;
    private boolean readOnly;
    private boolean useLabels;
    private boolean usersList;
    private boolean useCheckbox;
    private final boolean storeInRows;
    private boolean editLink;
    private String body;
    private final List<SelectOption> options;
    private String optionIds;
    private char tableSortType;
    private String usersGroup;
    private final String stylesheetClass;

    public Column(String heading, String width, String stylesheetClass, char tableSortType, boolean readOnly, boolean storeInRows) {
        this.readOnly = readOnly;
        this.setHeading(heading);
        this.width = width;
        this.options = new ArrayList<SelectOption>();
        this.options.add(new SelectOption("", ""));
        this.tableSortType = tableSortType;
        this.storeInRows = storeInRows;
        this.stylesheetClass = stylesheetClass;
    }

    public Column(String heading, int type, String width, String stylesheetClass, char tableSortType, boolean readOnly, boolean storeInRows) {
        this(heading, width, stylesheetClass, tableSortType, readOnly, storeInRows);
        this.type = type;
    }

    public static int parseType(String strType) {
        if (StringUtils.isBlank((CharSequence)strType)) {
            return 0;
        }
        for (int i = 1; i < TYPES.length; ++i) {
            if (!strType.equals(TYPES[i])) continue;
            return i;
        }
        return 0;
    }

    public static void setLabelManager(LabelManager labelManager) {
        Column.labelManager = labelManager;
    }

    public boolean isLabel() {
        return this.type == 1;
    }

    public boolean isInput() {
        return this.type == 2;
    }

    public boolean isExcerpt() {
        return this.type == 3;
    }

    public boolean isWiki() {
        return this.type == 5;
    }

    public boolean isWikiInput() {
        return this.type == 6;
    }

    public boolean isInclude() {
        return this.type == 4;
    }

    public CellHandler getCellHandler() {
        return CELL_HANDLERS[this.type];
    }

    public void setHeading(String heading) {
        if (heading != null) {
            this.heading = heading;
            this.id = Integer.toString(Math.abs(heading.hashCode()));
        }
    }

    public void setLabel(String labelName) {
        this.label = labelManager.getLabel(labelName);
        if (this.label == null) {
            this.label = labelManager.createLabel(new Label(labelName));
        }
    }

    public Object getKey() {
        if (this.isLabel()) {
            return this.label;
        }
        return this.heading;
    }

    public String getKey(Page row) {
        if (this.storeInRows) {
            return this.getKey().toString();
        }
        return this.getKey().toString() + "." + row.getSpaceKey() + ":" + row.getTitle();
    }

    public String getKey_v1_2(Page row) {
        if (this.storeInRows) {
            return this.getKey().toString();
        }
        return this.getKey().toString() + "." + row.getTitle();
    }

    public String getOptionIds() {
        if (this.optionIds == null) {
            if (!this.useLabels && !this.useCheckbox) {
                this.optionIds = "";
            } else {
                StringBuilder ops = new StringBuilder();
                Iterator<SelectOption> i = this.options.iterator();
                while (i.hasNext()) {
                    SelectOption option = i.next();
                    if (!StringUtils.isNotBlank((CharSequence)option.getId())) continue;
                    ops.append(option.getId());
                    if (!i.hasNext()) continue;
                    ops.append('|');
                }
                this.optionIds = ops.toString();
            }
        }
        return this.optionIds;
    }

    public void setOptionIds(String optionIds) {
        this.optionIds = optionIds;
        this.useLabels = StringUtils.isNotBlank((CharSequence)optionIds);
    }

    public void addOption(String option, String id) {
        this.options.add(new SelectOption(option, id));
    }

    public boolean hasBody() {
        return StringUtils.isNotBlank((CharSequence)this.body);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Generated
    public String getHeading() {
        return this.heading;
    }

    @Generated
    public void setType(int type) {
        this.type = type;
    }

    @Generated
    public int getType() {
        return this.type;
    }

    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public Label getLabel() {
        return this.label;
    }

    @Generated
    public void setCols(int cols) {
        this.cols = cols;
    }

    @Generated
    public int getCols() {
        return this.cols;
    }

    @Generated
    public void setRows(int rows) {
        this.rows = rows;
    }

    @Generated
    public int getRows() {
        return this.rows;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getWidth() {
        return this.width;
    }

    @Generated
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Generated
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Generated
    public void setUseLabels(boolean useLabels) {
        this.useLabels = useLabels;
    }

    @Generated
    public boolean isUseLabels() {
        return this.useLabels;
    }

    @Generated
    public void setUsersList(boolean usersList) {
        this.usersList = usersList;
    }

    @Generated
    public boolean isUsersList() {
        return this.usersList;
    }

    @Generated
    public void setUseCheckbox(boolean useCheckbox) {
        this.useCheckbox = useCheckbox;
    }

    @Generated
    public boolean isUseCheckbox() {
        return this.useCheckbox;
    }

    @Generated
    public boolean isStoreInRows() {
        return this.storeInRows;
    }

    @Generated
    public void setEditLink(boolean editLink) {
        this.editLink = editLink;
    }

    @Generated
    public boolean isEditLink() {
        return this.editLink;
    }

    @Generated
    public void setBody(String body) {
        this.body = body;
    }

    @Generated
    public String getBody() {
        return this.body;
    }

    @Generated
    public List<SelectOption> getOptions() {
        return this.options;
    }

    @Generated
    public void setTableSortType(char tableSortType) {
        this.tableSortType = tableSortType;
    }

    @Generated
    public char getTableSortType() {
        return this.tableSortType;
    }

    @Generated
    public void setUsersGroup(String usersGroup) {
        this.usersGroup = usersGroup;
    }

    @Generated
    public String getUsersGroup() {
        return this.usersGroup;
    }

    @Generated
    public String getStylesheetClass() {
        return this.stylesheetClass;
    }
}

