/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.checklists.model;

import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.pages.Page;
import com.comalatech.confluence.checklists.ChecklistManager;
import com.comalatech.confluence.checklists.model.Column;
import com.comalatech.confluence.checklists.model.Row;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class Checklist {
    public static final int MAX_SORT_VALUE_LENGTH = 20;
    public static final String SORT_NAME = "name";
    public static final String SORT_CREATED = "created";
    public static final String SORT_MODIFIED = "modified";
    public static final String[] SORT_TYPES = new String[]{"name", "created", "modified"};
    private static final String DEFAULT_STYLESHEET_CLASS = "grid";
    private List<Row> rows;
    private final SpaceContentEntityObject entity;
    private String name;
    private final List<Page> pages;
    private final List<Column> columns;
    private String id;
    private final char sortType;
    private final String stylesheetClass;

    public Checklist(SpaceContentEntityObject entity, String name, String sortKey, String stylesheetClass, List<Page> pages, List<Column> columns) {
        this.entity = entity;
        this.setName(name);
        this.pages = pages;
        this.columns = columns;
        this.rows = Collections.synchronizedList(new ArrayList());
        this.sortType = (char)(sortKey.equals(SORT_NAME) ? 83 : 70);
        this.stylesheetClass = StringUtils.isNotBlank((CharSequence)stylesheetClass) ? stylesheetClass : DEFAULT_STYLESHEET_CLASS;
        for (Page child : pages) {
            Row row = new Row(child, this.id);
            if (sortKey.equals(SORT_MODIFIED)) {
                date = child.getLastModificationDate().getTime();
                row.setPageDateSortValue(date);
                row.setPageSortValue(Long.toString(date));
            } else if (sortKey.equals(SORT_CREATED)) {
                date = child.getCreationDate().getTime();
                row.setPageDateSortValue(date);
                row.setPageSortValue(Long.toString(date));
            } else {
                row.setPageSortValue(Checklist.makeSortValue(child.getTitle()));
            }
            this.rows.add(row);
        }
        this.rows.sort((r1, r2) -> {
            if (this.sortType == 'S') {
                return r1.getPageSortValue().compareTo(r2.getPageSortValue());
            }
            if (r1.getPageDateSortValue() <= r2.getPageDateSortValue()) {
                return -1;
            }
            return 1;
        });
    }

    public static String makeSortValue(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return "0000000000";
        }
        char[] chars = value.toCharArray();
        int size = 0;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; size < 20 && i < chars.length; ++i) {
            char ch = chars[i];
            if (!Character.isLetterOrDigit(ch) && ch != '.' && ch != '-') continue;
            sb.append(Character.toUpperCase(ch));
            ++size;
        }
        return sb.toString();
    }

    public void setName(String name) {
        this.name = name;
        this.id = ChecklistManager.makeId(name);
    }

    public Set<String> getUniqueColumnTypes() {
        HashSet<String> columnNames = new HashSet<String>();
        for (Column column : this.columns) {
            columnNames.add(column.getTypeName());
        }
        return columnNames;
    }

    public String getEntityId() {
        return this.entity.getIdAsString();
    }

    @Generated
    public List<Row> getRows() {
        return this.rows;
    }

    @Generated
    public SpaceContentEntityObject getEntity() {
        return this.entity;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<Page> getPages() {
        return this.pages;
    }

    @Generated
    public List<Column> getColumns() {
        return this.columns;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public char getSortType() {
        return this.sortType;
    }

    @Generated
    public String getStylesheetClass() {
        return this.stylesheetClass;
    }

    @Generated
    public void setRows(List<Row> rows) {
        this.rows = rows;
    }
}

