/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.checklists.macro;

import com.atlassian.confluence.pages.Page;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.renderer.v2.macro.MacroManager;
import com.comalatech.confluence.adhoccanvas.macro.AdhocCanvasColumn;
import com.comalatech.confluence.adhoccanvas.macro.AdhocMetadataColumnMacro;
import com.comalatech.confluence.checklists.ValueManager;
import com.comalatech.confluence.checklists.macro.AbstractColumnMacro;
import com.comalatech.confluence.checklists.model.Column;
import com.comalatech.confluence.checklists.model.ColumnType;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@AdhocCanvasColumn(value=AdhocMetadataColumnMacro.class)
public class ChecklistMetadataMacro
extends AbstractColumnMacro {
    public static final String PARAM_NAME = "name";
    final MacroManager macroManager;

    public ChecklistMetadataMacro(ValueManager valueManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport MacroManager macroManager) {
        super(valueManager, pluginAccessor);
        this.macroManager = macroManager;
    }

    @Override
    public void parseColumnParameters(Page page, Map parameters, String body, Column column) throws MacroException {
        String name = this.getParameter(page, parameters, PARAM_NAME);
        if (StringUtils.isBlank((CharSequence)name)) {
            name = column.getHeading();
        }
        column.setType(5);
        column.setTypeName(ColumnType.METADATA.typeName);
        if (this.macroManager.getEnabledMacro("metadata-from") != null) {
            column.setBody("{metadata-from:" + name + "}");
        } else {
            column.setBody("{checklist-attribute:attribute=" + name + "}");
        }
        column.setReadOnly(true);
    }
}

