/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.checklists.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.core.TimeZone;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.changelog.ChangeLogManager;
import com.comalatech.confluence.changelog.model.ChangeLogEntry;
import com.comalatech.confluence.checklists.ChecklistManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;

public class ChecklistLogMacro
extends BaseMacro
implements Macro {
    private static final String RAW_PARAMS_KEY = ": = | RAW | = :";
    public static final String[] FORMATS = new String[]{"date", "dateanduser", "detailed", "newvalue", "oldvalue", "simple", "user", "useranddate"};
    private static final String PARAM_PAGE = "page";
    private static final String PARAM_MAXENTRIES = "maxentries";
    private static final String PARAM_MAXENTRIESPERNAME = "maxentriespername";
    private static final String PARAM_MOSTRECENTFIRST = "mostrecentfirst";
    private static final String PARAM_FORMAT = "format";
    private final ChecklistManager checklistManager;
    private final ChangeLogManager changeLogManager;
    private final SubRenderer subRenderer;
    private final UserAccessor userAccessor;
    private final FormatSettingsManager formatSettingsManager;
    private final LocaleManager localeManager;
    private final VelocityHelperService velocityHelperService;

    public ChecklistLogMacro(ChecklistManager checklistManager, ChangeLogManager changeLogManager, @ComponentImport SubRenderer subRenderer, @ComponentImport UserAccessor userAccessor, @ComponentImport FormatSettingsManager formatSettingsManager, @ComponentImport LocaleManager localeManager, @ComponentImport VelocityHelperService velocityHelperService) {
        this.checklistManager = checklistManager;
        this.changeLogManager = changeLogManager;
        this.subRenderer = subRenderer;
        this.userAccessor = userAccessor;
        this.formatSettingsManager = formatSettingsManager;
        this.localeManager = localeManager;
        this.velocityHelperService = velocityHelperService;
    }

    public boolean hasBody() {
        return false;
    }

    public String execute(Map<String, String> parameters, String body, ConversionContext context) throws MacroExecutionException {
        try {
            return this.execute(parameters, body, context.getRenderContext());
        }
        catch (MacroException e) {
            throw new MacroExecutionException(e.getMessage());
        }
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        String pageTitle = (String)parameters.get(PARAM_PAGE);
        String strmaxentries = (String)parameters.get(PARAM_MAXENTRIES);
        String strmaxentriespername = (String)parameters.get(PARAM_MAXENTRIESPERNAME);
        String strmostrencentfirst = (String)parameters.get(PARAM_MOSTRECENTFIRST);
        String format = (String)parameters.get(PARAM_FORMAT);
        Page page = (Page)((PageContext)renderContext).getEntity();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)pageTitle) && (page = this.checklistManager.getPageByTitleAndSpace(page.getSpaceKey(), pageTitle)) == null) {
            throw new MacroException("page " + pageTitle + " does not exist");
        }
        int maxEntries = 0;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)strmaxentries)) {
            try {
                maxEntries = Integer.parseInt(strmaxentries);
            }
            catch (NumberFormatException e) {
                throw new MacroException(" invalid value for maxentries");
            }
        }
        int maxEntriesPerName = 0;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)strmaxentriespername)) {
            try {
                maxEntriesPerName = Integer.parseInt(strmaxentriespername);
            }
            catch (NumberFormatException e) {
                throw new MacroException(" invalid value for maxentriespername");
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)format) && Arrays.binarySearch(FORMATS, format) < 0) {
            throw new MacroException("format can only be one of " + StringUtils.arrayToCommaDelimitedString((Object[])FORMATS));
        }
        boolean mostRecentFirst = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)strmostrencentfirst) || !strmostrencentfirst.equals("false");
        List<String> valueNames = this.parseValueNames(parameters);
        List<ChangeLogEntry> logEntries = this.changeLogManager.getChangeLog((ContentEntityObject)page, valueNames, maxEntries, maxEntriesPerName, mostRecentFirst);
        Map contextMap = MacroUtils.defaultVelocityContext();
        contextMap.put("logEntries", logEntries);
        contextMap.put("dateFormatter", this.getDateFormatter());
        contextMap.put(PARAM_FORMAT, format);
        try {
            return this.subRenderer.render(this.velocityHelperService.getRenderedTemplate("templates/changehistory.vm", contextMap), renderContext);
        }
        catch (Exception e) {
            throw new MacroException((Throwable)e);
        }
    }

    public DateFormatter getDateFormatter() {
        UserPreferences userPreferences = this.userAccessor.getUserPreferences(AuthenticatedUserThreadLocal.get());
        TimeZone zone = TimeZone.getInstance((String)String.valueOf(userPreferences.getString("confluence.user.time.zone")));
        return new DateFormatter(zone, this.formatSettingsManager, this.localeManager);
    }

    public List<String> parseValueNames(Map parameters) {
        String strallparams = parameters.get(RAW_PARAMS_KEY) != null ? (String)parameters.get(RAW_PARAMS_KEY) : "";
        ArrayList<String> allParams = new ArrayList<String>(List.of(strallparams.split("\\/")));
        return allParams.stream().filter(input -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)input) && !input.contains("=")).collect(Collectors.toList());
    }
}

