/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.checklists.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.checklists.ChecklistManager;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ChecklistAttributeMacro
extends BaseMacro
implements Macro {
    private static final String PARAM_ATTRIBUTE = "attribute";
    private static final String PARAM_PAGE = "page";
    private final ChecklistManager checklistManager;
    private final SubRenderer subRenderer;

    public ChecklistAttributeMacro(ChecklistManager checklistManager, @ComponentImport SubRenderer subRenderer) {
        this.checklistManager = checklistManager;
        this.subRenderer = subRenderer;
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public String execute(Map<String, String> parameters, String body, ConversionContext context) throws MacroExecutionException {
        try {
            return this.execute(parameters, body, context.getRenderContext());
        }
        catch (MacroException e) {
            throw new MacroExecutionException(e.getMessage());
        }
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        Page page;
        String pageName = (String)parameters.get(PARAM_PAGE);
        String attribute = (String)parameters.get(PARAM_ATTRIBUTE);
        if (StringUtils.isBlank((CharSequence)attribute)) {
            throw new MacroException("the attribute has to be defined");
        }
        Page thisPage = (Page)((PageContext)renderContext).getEntity();
        if (StringUtils.isNotBlank((CharSequence)pageName)) {
            page = this.checklistManager.getPageByTitleAndSpace(thisPage.getSpaceKey(), pageName);
            if (page == null) {
                throw new MacroException("page " + pageName + " does not exist");
            }
        } else {
            page = thisPage;
        }
        String text = this.checklistManager.getValue(page, attribute);
        return this.subRenderer.render(HtmlUtil.htmlEncode((String)text), renderContext, RenderMode.allow((long)8L));
    }
}

