/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.checklists.license;

import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.extras.api.LicenseType;
import com.atlassian.license.License;
import com.atlassian.license.LicenseManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.comalatech.confluence.checklists.license.ChecklistLicenseManager;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class DefaultChecklistLicenseManager
implements ChecklistLicenseManager {
    private final I18nResolver i18nResolver;
    private final PluginLicenseManager licenseManager;
    private final VelocityHelperService velocityHelperService;
    private static final String LICENSE_MSG_TEMPLATE = "templates/licenseMessage.vm";

    public DefaultChecklistLicenseManager(@ComponentImport I18nResolver i18nResolver, @ComponentImport PluginLicenseManager licenseManager, @ComponentImport VelocityHelperService velocityHelperService) {
        this.i18nResolver = i18nResolver;
        this.licenseManager = licenseManager;
        this.velocityHelperService = velocityHelperService;
    }

    @Override
    public Option<PluginLicense> getLicense() {
        return this.licenseManager.getLicense();
    }

    @Override
    public boolean isLicensed() {
        if (this.licenseManager.getLicense().isDefined()) {
            PluginLicense pluginLicense = (PluginLicense)this.licenseManager.getLicense().get();
            return !pluginLicense.getError().isDefined();
        }
        return false;
    }

    @Override
    public String getLicenseMessageHtml() {
        Map contextMap = MacroUtils.defaultVelocityContext();
        contextMap.put("licenseManager", this);
        contextMap.put("i18nResolver", this.i18nResolver);
        contextMap.put("license", this.getLicense());
        return this.velocityHelperService.getRenderedTemplate(LICENSE_MSG_TEMPLATE, contextMap);
    }

    @Override
    public boolean isDevelopmentMode() {
        boolean isAtlassianDevMode = Boolean.parseBoolean(System.getProperty("atlassian.dev.mode", "false"));
        boolean isComalatechDevMode = Boolean.parseBoolean(System.getProperty("comalatech.dev", "false"));
        return isAtlassianDevMode && isComalatechDevMode && this.isConfluenceDevLicence();
    }

    private boolean isConfluenceDevLicence() {
        com.atlassian.license.LicenseType licenseType;
        License confluenceLicense = LicenseManager.getInstance().getLicense("CONF");
        if (confluenceLicense != null && (licenseType = confluenceLicense.getLicenseType()) != null) {
            LicenseType type = LicenseType.valueOf((String)licenseType.getNewLicenseTypeName());
            return LicenseType.DEVELOPER.equals((Object)type) || LicenseType.TESTING.equals((Object)type);
        }
        return false;
    }
}

