/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.checklists;

import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.AddressablePage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.core.filters.ServletContextThreadLocal;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.struts.xsrf.XsrfTokenGenerator;
import com.comalatech.confluence.checklists.CellHandler;
import com.comalatech.confluence.checklists.model.Column;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.web.util.HtmlUtils;

public class PageRefCellHandler
extends CellHandler {
    @Override
    public String getValue(SpaceContentEntityObject entity, Page page, Column column) {
        return page.getIdAsString();
    }

    @Override
    public String makeSortValue(String value) {
        Page page = this.getChecklistManager().getPageAndLogNotFound(NumberUtils.createLong((String)value));
        if (page != null) {
            String escapedPageTitle = HtmlUtils.htmlEscape((String)page.getTitle());
            return super.makeSortValue(escapedPageTitle);
        }
        return "";
    }

    @Override
    public void setValue(SpaceContentEntityObject entity, Page page, Column column, String value) {
    }

    @Override
    public RenderMode getRenderMode() {
        return RenderMode.INLINE;
    }

    @Override
    public String renderValue(SubRenderer subRenderer, RenderContext renderContext, Column column, String value) {
        Page page = this.getChecklistManager().getPageAndLogNotFound(NumberUtils.createLong((String)value));
        if (page != null) {
            String escapedPageTitle = HtmlUtils.htmlEscape((String)page.getTitle());
            if (column.isEditLink()) {
                return "<a href=\"" + renderContext.getSiteRoot() + "/pages/editpage.action?pageId=" + page.getIdAsString() + "&atl_token=" + this.getAtlToken() + "\">" + escapedPageTitle + "</a>";
            }
            return "<a href=\"" + renderContext.getSiteRoot() + new AddressablePage((AbstractPage)page).getUrlPath() + "\">" + escapedPageTitle + "</a>";
        }
        return "cannot get " + value;
    }

    @Override
    public String getTemplate(Column column) {
        return null;
    }

    private String getAtlToken() {
        return PageRefCellHandler.getXsrfTokenGenerator().generateToken(ServletContextThreadLocal.getRequest());
    }

    private static XsrfTokenGenerator getXsrfTokenGenerator() {
        return (XsrfTokenGenerator)ComponentLocator.getComponent(XsrfTokenGenerator.class);
    }
}

