/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.checklists;

import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.SubRenderer;
import com.comalatech.confluence.checklists.ChecklistManager;
import com.comalatech.confluence.checklists.model.Checklist;
import com.comalatech.confluence.checklists.model.Column;
import com.comalatech.confluence.checklists.model.Row;
import java.util.Map;

public abstract class CellHandler {
    private static ChecklistManager checklistManager;
    private static XhtmlContent xhtmlContent;
    private static VelocityHelperService velocityHelperService;

    public abstract String getValue(SpaceContentEntityObject var1, Page var2, Column var3);

    public abstract void setValue(SpaceContentEntityObject var1, Page var2, Column var3, String var4);

    public String makeSortValue(String value) {
        return Checklist.makeSortValue(value);
    }

    public abstract RenderMode getRenderMode();

    public abstract String getTemplate(Column var1);

    public String renderValue(SubRenderer subRenderer, RenderContext renderContext, Column column, String value) {
        RenderMode renderMode = this.getRenderMode();
        if (renderMode != null) {
            value = subRenderer.render(value, renderContext, renderMode);
        }
        return value;
    }

    public String makeCellId(Row row, Column column) {
        if (column.isLabel()) {
            return "label_" + row.getGenericId() + "_" + column.getLabel().getName();
        }
        return row.getId() + column.getId();
    }

    public Map<String, Object> makeContextMap() {
        return MacroUtils.defaultVelocityContext();
    }

    public void makeCell(Checklist checklist, Row row, Column column, SubRenderer subRenderer, RenderContext renderContext) {
        String value = this.getValue(checklist.getEntity(), row.getPage(), column);
        String sortValue = this.makeSortValue(value);
        String cellId = this.makeCellId(row, column);
        String renderedValue = this.renderValue(subRenderer, renderContext, column, value);
        String template = this.getTemplate(column);
        if (template != null) {
            Map<String, Object> contextMap = this.makeContextMap();
            contextMap.put("checklistId", checklist.getId());
            contextMap.put("page", row.getPage());
            contextMap.put("cellId", cellId);
            contextMap.put("readonly", this.isReadOnly(checklist.getEntity(), row, column));
            contextMap.put("unrenderedValue", value);
            contextMap.put("renderedValueHtml", renderedValue);
            contextMap.put("sortValue", sortValue);
            contextMap.put("column", column);
            renderedValue = velocityHelperService.getRenderedTemplate(template, contextMap);
        }
        row.setValues(column.getKey(), cellId, value, sortValue, renderedValue);
    }

    private boolean isReadOnly(SpaceContentEntityObject entity, Row row, Column column) {
        if (column.isStoreInRows()) {
            return row.isReadOnly() || column.isReadOnly();
        }
        return column.isReadOnly() || !checklistManager.canEdit(entity);
    }

    public ChecklistManager getChecklistManager() {
        return checklistManager;
    }

    public static void setChecklistManager(ChecklistManager checklistManager) {
        CellHandler.checklistManager = checklistManager;
    }

    public XhtmlContent getXhtmlContent() {
        return xhtmlContent;
    }

    public static void setXhtmlContent(XhtmlContent xhtmlContent) {
        CellHandler.xhtmlContent = xhtmlContent;
    }

    public static void setVelocityHelperService(VelocityHelperService velocityHelperService) {
        CellHandler.velocityHelperService = velocityHelperService;
    }
}

