/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.changelog;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.setup.xstream.ConfluenceXStreamInternal;
import com.atlassian.confluence.setup.xstream.ConfluenceXStreamManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.changelog.ChangeLogEntryComparator;
import com.comalatech.confluence.changelog.model.ChangeLogEntry;
import com.comalatech.confluence.utils.MetadataSerializer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ChangeLogManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChangeLogManager.class);
    private static final String CHANGELOG_PREFIX = "changelog.";
    private final ConfluenceXStreamManager xStreamManager;
    private final MetadataSerializer metadataSerializer;
    private ConfluenceXStreamInternal xStream;

    public ChangeLogManager(MetadataSerializer metadataSerializer, @ComponentImport ConfluenceXStreamManager xStreamManager) {
        this.metadataSerializer = metadataSerializer;
        this.xStreamManager = xStreamManager;
        this.registerXStreamTypes();
    }

    public void logChange(ContentEntityObject contentEntityObject, String valueName, String oldValue, String newValue) {
        this.logChange(contentEntityObject, valueName, oldValue, newValue, false);
    }

    public void logLabelChange(ContentEntityObject contentEntityObject, String labelName, boolean added) {
        this.logChange(contentEntityObject, labelName, null, added ? "Added" : "Removed", true);
    }

    private void logChange(ContentEntityObject contentEntityObject, String valueName, String oldValue, String newValue, boolean isLabel) {
        if (valueName.startsWith(CHANGELOG_PREFIX)) {
            return;
        }
        String key = this.makeChangeLogKey(valueName);
        List<ChangeLogEntry> changeLog = this.getChangeLog(contentEntityObject, key);
        ChangeLogEntry changeLogEntry = new ChangeLogEntry(AuthenticatedUserThreadLocal.get().getName(), new Date(), valueName, oldValue, newValue, isLabel);
        changeLog.addFirst(changeLogEntry);
        this.setChangeLog(contentEntityObject, key, changeLog);
    }

    public List<ChangeLogEntry> getChangeLog(ContentEntityObject contentEntityObject, List<String> valueNamesList, int maxEntries, int maxEntriesPerName, boolean mostRecentFirst) {
        String[] loggedNames;
        ArrayList<ChangeLogEntry> entries = new ArrayList<ChangeLogEntry>();
        for (String loggedName : loggedNames = this.metadataSerializer.getMetadataNames(contentEntityObject)) {
            List<ChangeLogEntry> nameEntries;
            if (!loggedName.startsWith(CHANGELOG_PREFIX)) continue;
            if (valueNamesList.isEmpty()) {
                nameEntries = this.getChangeLog(contentEntityObject, this.makeChangeLogKey(loggedName.substring(CHANGELOG_PREFIX.length())));
                entries.addAll(this.getChangeLogPortion(nameEntries, maxEntriesPerName, mostRecentFirst));
                continue;
            }
            if (!valueNamesList.contains(loggedName.substring(CHANGELOG_PREFIX.length()))) continue;
            nameEntries = this.getChangeLog(contentEntityObject, loggedName);
            entries.addAll(this.getChangeLogPortion(nameEntries, maxEntriesPerName, mostRecentFirst));
        }
        entries.sort(new ChangeLogEntryComparator(mostRecentFirst));
        if (maxEntries == 0 || entries.size() <= maxEntries) {
            return entries;
        }
        return entries.subList(0, maxEntries);
    }

    private List<ChangeLogEntry> getChangeLogPortion(List<ChangeLogEntry> allEntries, int maxEntries, boolean mostRecentFirst) {
        if (allEntries.isEmpty()) {
            return allEntries;
        }
        if (!mostRecentFirst) {
            allEntries.sort(new ChangeLogEntryComparator(mostRecentFirst));
        }
        if (maxEntries == 0 || allEntries.size() <= maxEntries) {
            return allEntries;
        }
        return allEntries.subList(0, maxEntries);
    }

    private List<ChangeLogEntry> getChangeLog(ContentEntityObject contentEntityObject, String logKey) {
        String rawlog = this.metadataSerializer.getMetadataValue(contentEntityObject, logKey);
        if (StringUtils.isBlank((CharSequence)rawlog)) {
            return new ArrayList<ChangeLogEntry>();
        }
        try {
            return (List)this.xStream.fromXML(rawlog);
        }
        catch (Exception e) {
            log.error("error deserializing change log. See CHK-29", (Throwable)e);
            return new ArrayList<ChangeLogEntry>();
        }
    }

    private void setChangeLog(ContentEntityObject contentEntityObject, String logKey, List<ChangeLogEntry> changeLog) {
        String rawLog = this.xStreamManager.getConfluenceXStream().toXML(changeLog);
        this.metadataSerializer.setMetadataValue(contentEntityObject, logKey, rawLog);
    }

    private String makeChangeLogKey(String valueName) {
        return CHANGELOG_PREFIX + valueName;
    }

    private void registerXStreamTypes() {
        this.xStream = (ConfluenceXStreamInternal)this.xStreamManager.getPluginXStream(this.getClass().getClassLoader());
        this.xStream.allowTypes(new String[]{"com.comalatech.confluence.changelog.model.ChangeLogEntry"});
    }
}

