/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.changelog;

import com.comalatech.confluence.changelog.model.ChangeLogEntry;
import java.util.Comparator;

public class ChangeLogEntryComparator
implements Comparator<ChangeLogEntry> {
    int orderFactor;

    public ChangeLogEntryComparator(boolean mostRecentFirst) {
        this.orderFactor = mostRecentFirst ? -1 : 1;
    }

    @Override
    public int compare(ChangeLogEntry c1, ChangeLogEntry c2) {
        long d2;
        long d2minutes;
        long d1 = c1.getDate().getTime();
        long d1minutes = d1 / 1000L / 60L;
        if (d1minutes < (d2minutes = (d2 = c2.getDate().getTime()) / 1000L / 60L)) {
            return -1 * this.orderFactor;
        }
        if (d1minutes == d2minutes) {
            int cmp = c1.getUserId().compareTo(c2.getUserId());
            if (cmp == 0) {
                if (d1 < d2) {
                    return -1 * this.orderFactor;
                }
                return this.orderFactor;
            }
            return cmp;
        }
        return this.orderFactor;
    }
}

