/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.checklists.model;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.pages.Page;
import com.comalatech.confluence.checklists.CellHandler;
import com.comalatech.confluence.checklists.ExcerptCellHandler;
import com.comalatech.confluence.checklists.IncludeCellHandler;
import com.comalatech.confluence.checklists.InputCellHandler;
import com.comalatech.confluence.checklists.LabelCellHandler;
import com.comalatech.confluence.checklists.PageRefCellHandler;
import com.comalatech.confluence.checklists.SelectCellHandler;
import com.comalatech.confluence.checklists.WikiCellHandler;
import com.comalatech.confluence.checklists.WikiInputCellHandler;
import com.comalatech.confluence.checklists.model.SelectOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Column {
    public static final int TYPE_NONE = 0;
    public static final int TYPE_LABEL = 1;
    public static final int TYPE_INPUT = 2;
    public static final int TYPE_EXCERPT = 3;
    public static final int TYPE_INCLUDE = 4;
    public static final int TYPE_WIKI = 5;
    public static final int TYPE_WIKIINPUT = 6;
    public static final int TYPE_SELECT = 7;
    public static final int TYPE_PAGEREF = 8;
    private static String[] TYPES = new String[]{"", "label", "text", "excerpt", "include", "wiki", "wikiinput", "select", "pageref"};
    private static CellHandler[] CELL_HANDLERS = new CellHandler[]{null, new LabelCellHandler(), new InputCellHandler(), new ExcerptCellHandler(), new IncludeCellHandler(), new WikiCellHandler(), new WikiInputCellHandler(), new SelectCellHandler(), new PageRefCellHandler()};
    private static LabelManager labelManager;
    private String heading;
    private int type;
    private String typeName;
    private Label label;
    private int cols;
    private int rows;
    private String id;
    private String width;
    private boolean readOnly;
    private boolean useLabels;
    private boolean usersList;
    private boolean useCheckbox;
    private boolean storeInRows;
    private boolean editLink;
    private String body;
    private List options;
    private String optionIds;
    private char tableSortType;
    private String usersGroup;
    private String stylesheetClass;

    public Column(String heading, String width, String stylesheetClass, char tableSortType, boolean readOnly, boolean storeInRows) {
        this.readOnly = readOnly;
        this.setHeading(heading);
        this.width = width;
        this.options = new ArrayList();
        this.options.add(new SelectOption("", ""));
        this.tableSortType = tableSortType;
        this.storeInRows = storeInRows;
        this.stylesheetClass = stylesheetClass;
    }

    public Column(String heading, int type, String width, String stylesheetClass, char tableSortType, boolean readOnly, boolean storeInRows) {
        this(heading, width, stylesheetClass, tableSortType, readOnly, storeInRows);
        this.type = type;
    }

    public static int parseType(String strType) {
        if (StringUtils.isBlank((CharSequence)strType)) {
            return 0;
        }
        for (int i = 1; i < TYPES.length; ++i) {
            if (!strType.equals(TYPES[i])) continue;
            return i;
        }
        return 0;
    }

    public static void setLabelManager(LabelManager labelManager) {
        Column.labelManager = labelManager;
    }

    public boolean isStoreInRows() {
        return this.storeInRows;
    }

    public String getStylesheetClass() {
        return this.stylesheetClass;
    }

    public boolean isLabel() {
        return this.type == 1;
    }

    public boolean isInput() {
        return this.type == 2;
    }

    public boolean isExcerpt() {
        return this.type == 3;
    }

    public boolean isWiki() {
        return this.type == 5;
    }

    public boolean isWikiInput() {
        return this.type == 6;
    }

    public boolean isEditLink() {
        return this.editLink;
    }

    public void setEditLink(boolean editLink) {
        this.editLink = editLink;
    }

    public boolean isUseCheckbox() {
        return this.useCheckbox;
    }

    public void setUseCheckbox(boolean useCheckbox) {
        this.useCheckbox = useCheckbox;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isInclude() {
        return this.type == 4;
    }

    public char getTableSortType() {
        return this.tableSortType;
    }

    public void setTableSortType(char tableSortType) {
        this.tableSortType = tableSortType;
    }

    public CellHandler getCellHandler() {
        return CELL_HANDLERS[this.type];
    }

    public String getHeading() {
        return this.heading;
    }

    public void setHeading(String heading) {
        this.heading = heading;
        this.id = Integer.toString(Math.abs(heading.hashCode()));
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Label getLabel() {
        return this.label;
    }

    public void setLabel(String labelName) {
        this.label = labelManager.getLabel(labelName);
        if (this.label == null) {
            this.label = labelManager.createLabel(new Label(labelName));
        }
    }

    public String getId() {
        return this.id;
    }

    public Object getKey() {
        if (this.isLabel()) {
            return this.label;
        }
        return this.heading;
    }

    public String getKey(Page row) {
        if (this.storeInRows) {
            return this.getKey().toString();
        }
        return this.getKey().toString() + "." + row.getSpaceKey() + ":" + row.getTitle();
    }

    public String getKey_v1_2(Page row) {
        if (this.storeInRows) {
            return this.getKey().toString();
        }
        return this.getKey().toString() + "." + row.getTitle();
    }

    public int getCols() {
        return this.cols;
    }

    public void setCols(int cols) {
        this.cols = cols;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public String getWidth() {
        return this.width;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public List getOptions() {
        return this.options;
    }

    public String getOptionIds() {
        if (this.optionIds == null) {
            if (!this.useLabels && !this.useCheckbox) {
                this.optionIds = "";
            } else {
                StringBuilder ops = new StringBuilder();
                Iterator i = this.options.iterator();
                while (i.hasNext()) {
                    SelectOption option = (SelectOption)i.next();
                    if (!StringUtils.isNotBlank((CharSequence)option.getId())) continue;
                    ops.append(option.getId());
                    if (!i.hasNext()) continue;
                    ops.append('|');
                }
                this.optionIds = ops.toString();
            }
        }
        return this.optionIds;
    }

    public void setOptionIds(String optionIds) {
        this.optionIds = optionIds;
        this.useLabels = StringUtils.isNotBlank((CharSequence)optionIds);
    }

    public void addOption(String option, String id) {
        this.options.add(new SelectOption(option, id));
    }

    public boolean hasBody() {
        return StringUtils.isNotBlank((CharSequence)this.body);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public boolean isUseLabels() {
        return this.useLabels;
    }

    public void setUseLabels(boolean useLabels) {
        this.useLabels = useLabels;
    }

    public boolean isUsersList() {
        return this.usersList;
    }

    public void setUsersList(boolean usersList) {
        this.usersList = usersList;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getUsersGroup() {
        return this.usersGroup;
    }

    public void setUsersGroup(String usersGroup) {
        this.usersGroup = usersGroup;
    }
}

