/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.checklists.macro;

import com.atlassian.confluence.pages.Page;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.adhoccanvas.macro.AdhocCanvasColumn;
import com.comalatech.confluence.adhoccanvas.macro.AdhocWikiInputColumnMacro;
import com.comalatech.confluence.checklists.ValueManager;
import com.comalatech.confluence.checklists.macro.AbstractColumnMacro;
import com.comalatech.confluence.checklists.model.Column;
import com.comalatech.confluence.checklists.model.ColumnType;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@AdhocCanvasColumn(value=AdhocWikiInputColumnMacro.class)
public class ChecklistWikiInputMacro
extends AbstractColumnMacro {
    public ChecklistWikiInputMacro(ValueManager valueManager, @ComponentImport PluginAccessor pluginAccessor) {
        super(valueManager, pluginAccessor);
    }

    @Override
    public void parseColumnParameters(Page page, Map parameters, String body, Column column) throws MacroException {
        String cols = this.getParameter(page, parameters, "cols");
        String rows = this.getParameter(page, parameters, "rows");
        column.setType(6);
        column.setTypeName(ColumnType.WIKIINPUT.typeName);
        if (StringUtils.isBlank((CharSequence)cols)) {
            throw new MacroException("cols not set in column " + column.getHeading());
        }
        try {
            column.setCols(Integer.parseInt(cols));
        }
        catch (NumberFormatException e) {
            throw new MacroException("invalid cols in column " + column.getHeading());
        }
        if (StringUtils.isNotBlank((CharSequence)rows)) {
            try {
                column.setRows(Integer.parseInt(rows));
            }
            catch (NumberFormatException e) {
                throw new MacroException("invalid rows in column " + column.getHeading());
            }
        } else {
            column.setRows(1);
        }
    }
}

